package ru.vizzi.bp.packet;

import hohserg.elegant.networking.impl.ISerializer;
import hohserg.elegant.networking.impl.SerializerMark;
import io.netty.buffer.ByteBuf;

@SerializerMark(
    packetClass = ru.vizzi.bp.packet.PacketGetReward.class
)
public class PacketGetRewardSerializer implements ISerializer<PacketGetReward> {
  public void serialize(PacketGetReward value, ByteBuf acc) {
    serialize_PacketGetReward_Generic(value, acc);
  }

  public PacketGetReward unserialize(ByteBuf buf) {
    return unserialize_PacketGetReward_Generic(buf);
  }

  void serialize_PacketGetReward_Generic(PacketGetReward value, ByteBuf acc) {
    serialize_PacketGetReward_Concretic(value, acc);
  }

  PacketGetReward unserialize_PacketGetReward_Generic(ByteBuf buf) {
    return unserialize_PacketGetReward_Concretic(buf);
  }

  void serialize_PacketGetReward_Concretic(PacketGetReward value, ByteBuf acc) {
    serialize_Int_Generic(value.getId(), acc);
    serialize_Boolean_Generic(value.isDonate(), acc);
  }

  PacketGetReward unserialize_PacketGetReward_Concretic(ByteBuf buf) {
    PacketGetReward value = new PacketGetReward(unserialize_Int_Generic(buf), unserialize_Boolean_Generic(buf));
    return value;
  }
}
