package ru.vizzi.bp.packet;

import hohserg.elegant.networking.impl.ISerializer;
import hohserg.elegant.networking.impl.SerializerMark;
import io.netty.buffer.ByteBuf;

@SerializerMark(
    packetClass = ru.vizzi.bp.packet.PacketOpenGui.class
)
public class PacketOpenGuiSerializer implements ISerializer<PacketOpenGui> {
  public void serialize(PacketOpenGui value, ByteBuf acc) {
    serialize_PacketOpenGui_Generic(value, acc);
  }

  public PacketOpenGui unserialize(ByteBuf buf) {
    return unserialize_PacketOpenGui_Generic(buf);
  }

  void serialize_PacketOpenGui_Generic(PacketOpenGui value, ByteBuf acc) {
    serialize_PacketOpenGui_Concretic(value, acc);
  }

  PacketOpenGui unserialize_PacketOpenGui_Generic(ByteBuf buf) {
    return unserialize_PacketOpenGui_Concretic(buf);
  }

  void serialize_PacketOpenGui_Concretic(PacketOpenGui value, ByteBuf acc) {
    serialize_Boolean_Generic(value.isDebug(), acc);
  }

  PacketOpenGui unserialize_PacketOpenGui_Concretic(ByteBuf buf) {
    PacketOpenGui value = new PacketOpenGui(unserialize_Boolean_Generic(buf));
    return value;
  }
}
