package ru.vizzi.bp.packet;

import hohserg.elegant.networking.impl.ISerializer;
import hohserg.elegant.networking.impl.SerializerMark;
import io.netty.buffer.ByteBuf;

@SerializerMark(
    packetClass = ru.vizzi.bp.packet.PacketSyncClientData.class
)
public class PacketSyncClientDataSerializer implements ISerializer<PacketSyncClientData> {
  public void serialize(PacketSyncClientData value, ByteBuf acc) {
    serialize_PacketSyncClientData_Generic(value, acc);
  }

  public PacketSyncClientData unserialize(ByteBuf buf) {
    return unserialize_PacketSyncClientData_Generic(buf);
  }

  void serialize_PacketSyncClientData_Generic(PacketSyncClientData value, ByteBuf acc) {
    serialize_PacketSyncClientData_Concretic(value, acc);
  }

  PacketSyncClientData unserialize_PacketSyncClientData_Generic(ByteBuf buf) {
    return unserialize_PacketSyncClientData_Concretic(buf);
  }

  void serialize_PacketSyncClientData_Concretic(PacketSyncClientData value, ByteBuf acc) {
    serialize_Boolean_Generic(value.isBuy, acc);
    serialize_Int_Generic(value.costPass, acc);
    serialize_Long_Generic(value.battlePassTime, acc);
  }

  PacketSyncClientData unserialize_PacketSyncClientData_Concretic(ByteBuf buf) {
    PacketSyncClientData value = new PacketSyncClientData(unserialize_Boolean_Generic(buf), unserialize_Int_Generic(buf), unserialize_Long_Generic(buf));
    return value;
  }
}
