package ru.vizzi.bp.packet;

import hohserg.elegant.networking.impl.ISerializer;
import hohserg.elegant.networking.impl.SerializerMark;
import io.netty.buffer.ByteBuf;

@SerializerMark(
    packetClass = ru.vizzi.bp.packet.PacketSyncOneReward.class
)
public class PacketSyncOneRewardSerializer implements ISerializer<PacketSyncOneReward> {
  public void serialize(PacketSyncOneReward value, ByteBuf acc) {
    serialize_PacketSyncOneReward_Generic(value, acc);
  }

  public PacketSyncOneReward unserialize(ByteBuf buf) {
    return unserialize_PacketSyncOneReward_Generic(buf);
  }

  void serialize_PacketSyncOneReward_Generic(PacketSyncOneReward value, ByteBuf acc) {
    serialize_PacketSyncOneReward_Concretic(value, acc);
  }

  PacketSyncOneReward unserialize_PacketSyncOneReward_Generic(ByteBuf buf) {
    return unserialize_PacketSyncOneReward_Concretic(buf);
  }

  void serialize_PacketSyncOneReward_Concretic(PacketSyncOneReward value, ByteBuf acc) {
    serialize_Int_Generic(value.getId(), acc);
    serialize_NBTTagCompound_Generic(value.getTagCompound(), acc);
  }

  PacketSyncOneReward unserialize_PacketSyncOneReward_Concretic(ByteBuf buf) {
    PacketSyncOneReward value = new PacketSyncOneReward(unserialize_Int_Generic(buf), unserialize_NBTTagCompound_Generic(buf));
    return value;
  }
}
