package ru.vizzi.bp.packet;

import hohserg.elegant.networking.impl.ISerializer;
import hohserg.elegant.networking.impl.SerializerMark;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import ru.vizzi.bp.event.TaskClient;
import ru.vizzi.bp.event.task.TaskType;

@SerializerMark(
    packetClass = ru.vizzi.bp.packet.PacketSyncTask.class
)
public class PacketSyncTaskSerializer implements ISerializer<PacketSyncTask> {
  public void serialize(PacketSyncTask value, ByteBuf acc) {
    serialize_PacketSyncTask_Generic(value, acc);
  }

  public PacketSyncTask unserialize(ByteBuf buf) {
    return unserialize_PacketSyncTask_Generic(buf);
  }

  void serialize_ArrayList_of_TaskClient_Generic(ArrayList<TaskClient> value, ByteBuf acc) {
    acc.writeInt(value.size());
    for (TaskClient e :value) {
      serialize_TaskClient_Generic(e,acc);
    }
  }

  ArrayList<TaskClient> unserialize_ArrayList_of_TaskClient_Generic(ByteBuf buf) {
    int size = buf.readInt();
    java.util.ArrayList value = new java.util.ArrayList();
    for (int i=0;i<size;i++) {
      TaskClient e = unserialize_TaskClient_Generic(buf);
      value.add(e);
    }
    return value;
  }

  void serialize_TaskClient_Generic(TaskClient value, ByteBuf acc) {
    serialize_TaskClient_Concretic(value, acc);
  }

  TaskClient unserialize_TaskClient_Generic(ByteBuf buf) {
    return unserialize_TaskClient_Concretic(buf);
  }

  void serialize_TaskClient_Concretic(TaskClient value, ByteBuf acc) {
    serialize_Int_Generic(value.getId(), acc);
    serialize_TaskType_Generic(value.getTaskType(), acc);
    serialize_String_Generic(value.getLocal(), acc);
    serialize_Int_Generic(value.getMaxCount(), acc);
    serialize_Int_Generic(value.getCurrentCount(), acc);
    serialize_Int_Generic(value.getRewardPoint(), acc);
    serialize_ItemStack_Generic(value.getItemStack(), acc);
  }

  TaskClient unserialize_TaskClient_Concretic(ByteBuf buf) {
    TaskClient value = new TaskClient();
    value.setId(unserialize_Int_Generic(buf));
    value.setTaskType(unserialize_TaskType_Generic(buf));
    value.setLocal(unserialize_String_Generic(buf));
    value.setMaxCount(unserialize_Int_Generic(buf));
    value.setCurrentCount(unserialize_Int_Generic(buf));
    value.setRewardPoint(unserialize_Int_Generic(buf));
    value.setItemStack(unserialize_ItemStack_Generic(buf));
    return value;
  }

  void serialize_TaskType_Generic(TaskType value, ByteBuf acc) {
    acc.writeByte(value.ordinal());
  }

  TaskType unserialize_TaskType_Generic(ByteBuf buf) {
    return TaskType.values()[buf.readByte()];
  }

  void serialize_PacketSyncTask_Generic(PacketSyncTask value, ByteBuf acc) {
    serialize_PacketSyncTask_Concretic(value, acc);
  }

  PacketSyncTask unserialize_PacketSyncTask_Generic(ByteBuf buf) {
    return unserialize_PacketSyncTask_Concretic(buf);
  }

  void serialize_PacketSyncTask_Concretic(PacketSyncTask value, ByteBuf acc) {
    serialize_ArrayList_of_TaskClient_Generic(value.getTaskClients(), acc);
    serialize_Boolean_Generic(value.isWeek(), acc);
  }

  PacketSyncTask unserialize_PacketSyncTask_Concretic(ByteBuf buf) {
    PacketSyncTask value = new PacketSyncTask(unserialize_ArrayList_of_TaskClient_Generic(buf), unserialize_Boolean_Generic(buf));
    return value;
  }
}
