package ru.vizzi.bp.packet;

import hohserg.elegant.networking.impl.ISerializer;
import hohserg.elegant.networking.impl.SerializerMark;
import io.netty.buffer.ByteBuf;

@SerializerMark(
    packetClass = ru.vizzi.bp.packet.PacketTimeLeftDay.class
)
public class PacketTimeLeftDaySerializer implements ISerializer<PacketTimeLeftDay> {
  public void serialize(PacketTimeLeftDay value, ByteBuf acc) {
    serialize_PacketTimeLeftDay_Generic(value, acc);
  }

  public PacketTimeLeftDay unserialize(ByteBuf buf) {
    return unserialize_PacketTimeLeftDay_Generic(buf);
  }

  void serialize_PacketTimeLeftDay_Generic(PacketTimeLeftDay value, ByteBuf acc) {
    serialize_PacketTimeLeftDay_Concretic(value, acc);
  }

  PacketTimeLeftDay unserialize_PacketTimeLeftDay_Generic(ByteBuf buf) {
    return unserialize_PacketTimeLeftDay_Concretic(buf);
  }

  void serialize_PacketTimeLeftDay_Concretic(PacketTimeLeftDay value, ByteBuf acc) {
    serialize_Long_Generic(value.getTimeDay(), acc);
  }

  PacketTimeLeftDay unserialize_PacketTimeLeftDay_Concretic(ByteBuf buf) {
    PacketTimeLeftDay value = new PacketTimeLeftDay(unserialize_Long_Generic(buf));
    return value;
  }
}
