package ru.vizzi.bp.packet;

import hohserg.elegant.networking.impl.ISerializer;
import hohserg.elegant.networking.impl.SerializerMark;
import io.netty.buffer.ByteBuf;

@SerializerMark(
    packetClass = ru.vizzi.bp.packet.PacketTimeLeftWeek.class
)
public class PacketTimeLeftWeekSerializer implements ISerializer<PacketTimeLeftWeek> {
  public void serialize(PacketTimeLeftWeek value, ByteBuf acc) {
    serialize_PacketTimeLeftWeek_Generic(value, acc);
  }

  public PacketTimeLeftWeek unserialize(ByteBuf buf) {
    return unserialize_PacketTimeLeftWeek_Generic(buf);
  }

  void serialize_PacketTimeLeftWeek_Generic(PacketTimeLeftWeek value, ByteBuf acc) {
    serialize_PacketTimeLeftWeek_Concretic(value, acc);
  }

  PacketTimeLeftWeek unserialize_PacketTimeLeftWeek_Generic(ByteBuf buf) {
    return unserialize_PacketTimeLeftWeek_Concretic(buf);
  }

  void serialize_PacketTimeLeftWeek_Concretic(PacketTimeLeftWeek value, ByteBuf acc) {
    serialize_Long_Generic(value.getTimeWeek(), acc);
  }

  PacketTimeLeftWeek unserialize_PacketTimeLeftWeek_Concretic(ByteBuf buf) {
    PacketTimeLeftWeek value = new PacketTimeLeftWeek(unserialize_Long_Generic(buf));
    return value;
  }
}
