/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.general.gui.frame;

import java.util.List;
import net.machinemuse.general.gui.clickable.ClickableItem;
import net.machinemuse.general.gui.frame.IGuiFrame;
import net.machinemuse.general.gui.frame.ItemSelectionFrame;
import net.machinemuse.numina.general.MuseMathUtils;
import net.machinemuse.numina.geometry.Colour;
import net.machinemuse.numina.geometry.DrawableMuseRect;
import net.machinemuse.numina.geometry.MusePoint2D;
import net.machinemuse.powersuits.client.render.item.ArmorModelInstance;
import net.machinemuse.powersuits.client.render.item.IArmorModel;
import net.machinemuse.powersuits.item.ItemPowerArmor;
import net.machinemuse.utils.MuseItemUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class ItemModelViewFrame
implements IGuiFrame {
    ItemSelectionFrame itemSelector;
    DrawableMuseRect border;
    double anchorx = 0.0;
    double anchory = 0.0;
    int dragging = -1;
    double lastdWheel = 0.0;
    double rotx = 0.0;
    double roty = 0.0;
    double offsetx = 0.0;
    double offsety = 0.0;
    double zoom = 64.0;

    public ItemModelViewFrame(ItemSelectionFrame itemSelector, MusePoint2D topleft, MusePoint2D bottomright, Colour borderColour, Colour insideColour) {
        this.itemSelector = itemSelector;
        this.border = new DrawableMuseRect(topleft, bottomright, borderColour, insideColour);
    }

    int getArmorSlot() {
        return ((ItemPowerArmor)this.getSelectedItem().getItem().func_77973_b()).field_77881_a;
    }

    ClickableItem getSelectedItem() {
        return this.itemSelector.getSelectedItem();
    }

    NBTTagCompound getRenderTag() {
        return MuseItemUtils.getMuseRenderTag(this.getSelectedItem().getItem(), this.getArmorSlot());
    }

    @Override
    public void onMouseDown(double x, double y, int button) {
        if (this.border.containsPoint(x, y)) {
            this.dragging = button;
            this.anchorx = x;
            this.anchory = y;
        }
    }

    @Override
    public void onMouseUp(double x, double y, int button) {
        this.dragging = -1;
    }

    @Override
    public void update(double mousex, double mousey) {
        if (this.border.containsPoint(mousex, mousey)) {
            double dscroll = (this.lastdWheel - (double)Mouse.getDWheel()) / 120.0;
            this.zoom *= Math.pow(1.1, dscroll);
            this.lastdWheel = Mouse.getDWheel();
        }
        double dx = mousex - this.anchorx;
        double dy = mousey - this.anchory;
        switch (this.dragging) {
            case 0: {
                this.rotx = MuseMathUtils.clampDouble((double)(this.rotx + dy), (double)-90.0, (double)90.0);
                this.roty -= dx;
                this.anchorx = mousex;
                this.anchory = mousey;
                break;
            }
            case 1: {
                this.offsetx += dx;
                this.offsety += dy;
                this.anchorx = mousex;
                this.anchory = mousey;
                break;
            }
        }
    }

    @Override
    public void draw() {
        Minecraft mc = Minecraft.func_71410_x();
        this.border.draw();
        if (this.itemSelector.getSelectedItem() == null || !(this.getSelectedItem().getItem().func_77973_b() instanceof ItemPowerArmor)) {
            return;
        }
        GL11.glPushMatrix();
        ((IArmorModel)ArmorModelInstance.getInstance()).setRenderSpec(MuseItemUtils.getMuseRenderTag(this.getSelectedItem().getItem(), this.getArmorSlot()));
        ((IArmorModel)ArmorModelInstance.getInstance()).setVisibleSection(this.getArmorSlot());
        GL11.glTranslated((double)(this.border.centerx() + this.offsetx), (double)(this.border.centery() + this.offsety), (double)0.0);
        GL11.glScaled((double)this.zoom, (double)this.zoom, (double)this.zoom);
        GL11.glClear((int)256);
        GL11.glDisable((int)2884);
        GL11.glRotatef((float)((float)this.rotx), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)((float)this.roty), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslated((double)0.0, (double)((double)(-this.getArmorSlot()) / 2.0), (double)0.0);
        ArmorModelInstance.getInstance().func_78088_a((Entity)mc.field_71439_g, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        GL11.glPopMatrix();
    }

    @Override
    public List<String> getToolTip(int x, int y) {
        return null;
    }
}

