/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.client.render.modelspec;

import java.awt.Color;
import java.net.URL;
import javax.annotation.Nullable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.machinemuse.numina.general.MuseLogger;
import net.machinemuse.numina.geometry.Colour;
import net.machinemuse.powersuits.client.render.modelspec.ModelPartSpec;
import net.machinemuse.powersuits.client.render.modelspec.ModelRegistry;
import net.machinemuse.powersuits.client.render.modelspec.ModelSpec;
import net.machinemuse.powersuits.client.render.modelspec.MorphTarget;
import net.machinemuse.utils.MuseStringUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.model.obj.GroupObject;
import net.minecraftforge.client.model.obj.WavefrontObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ModelSpecXMLReader {
    private static ModelSpecXMLReader INSTANCE;

    private ModelSpecXMLReader() {
    }

    public static ModelSpecXMLReader getINSTANCE() {
        if (INSTANCE == null) {
            INSTANCE = new ModelSpecXMLReader();
        }
        return INSTANCE;
    }

    public void parseFile(URL file) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document xml = dBuilder.parse(new InputSource(file.openStream()));
            xml.getDocumentElement().normalize();
            NodeList modelNodeList = xml.getElementsByTagName("model");
            for (int temp = 0; temp < modelNodeList.getLength(); ++temp) {
                Node modelNode = modelNodeList.item(temp);
                if (modelNode.getNodeType() != 1) continue;
                this.parseModel(modelNode);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void parseModel(Node modelnode) {
        if (modelnode.getNodeType() == 1) {
            Element eElement = (Element)modelnode;
            String file = eElement.getAttribute("file");
            String[] textures = eElement.getAttribute("textures").split(",");
            Vec3 offset = this.parseVector(eElement.getAttribute("offset"));
            Vec3 rotation = this.parseVector(eElement.getAttribute("rotation"));
            WavefrontObject model = ModelRegistry.getInstance().loadModel(new ResourceLocation(file));
            if (model != null) {
                ModelSpec modelspec = new ModelSpec(model, textures, offset, rotation, file);
                ModelSpec existingspec = (ModelSpec)((Object)ModelRegistry.getInstance().put(MuseStringUtils.extractName(file), (Object)modelspec));
                NodeList bindingNodeList = eElement.getElementsByTagName("binding");
                for (int temp = 0; temp < bindingNodeList.getLength(); ++temp) {
                    Node bindingnode = bindingNodeList.item(temp);
                    this.parseBinding(bindingnode, existingspec);
                }
            } else {
                MuseLogger.logError((String)("Model file " + file + " not found! D:"));
            }
        }
    }

    public void parseBinding(Node bindingnode, ModelSpec modelspec) {
        if (bindingnode.getNodeType() == 1) {
            Element eElement = (Element)bindingnode;
            int slot = this.parseInt(eElement.getAttribute("slot"));
            MorphTarget target = this.parseTarget(eElement.getAttribute("target"));
            NodeList partNodeList = eElement.getElementsByTagName("part");
            for (int temp = 0; temp < partNodeList.getLength(); ++temp) {
                Node partnode = partNodeList.item(temp);
                this.parseParts(partnode, modelspec, slot, target);
            }
        }
    }

    public void parseParts(Node partNode, ModelSpec modelspec, int slot, MorphTarget target) {
        if (partNode.getNodeType() == 1) {
            Element eElement = (Element)partNode;
            Boolean defaultglow = this.parseBool(eElement.getAttribute("defaultglow"));
            String name = eElement.getAttribute("name");
            String polygroup = this.validatePolygroup(eElement.getAttribute("polygroup"), modelspec);
            if (polygroup != null) {
                ModelPartSpec partspec = new ModelPartSpec(modelspec, target, polygroup, slot, 0, defaultglow != null ? defaultglow : false, name);
                modelspec.put(polygroup, partspec);
            }
        }
    }

    @Nullable
    public String validatePolygroup(String s, ModelSpec m) {
        for (GroupObject groupObject : m.model.groupObjects) {
            if (!groupObject.name.equals(s)) continue;
            return s;
        }
        return null;
    }

    @Nullable
    public Boolean parseBool(String s) {
        try {
            return Boolean.parseBoolean(s);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public Colour parseColour(String s) {
        try {
            Color c = Color.decode(s);
            return new Colour((double)c.getRed(), (double)c.getGreen(), (double)c.getBlue(), (double)c.getAlpha());
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public MorphTarget parseTarget(String s) {
        switch (s.toLowerCase()) {
            case "head": {
                return MorphTarget.Head;
            }
            case "body": {
                return MorphTarget.Body;
            }
            case "leftarm": {
                return MorphTarget.LeftArm;
            }
            case "rightarm": {
                return MorphTarget.RightArm;
            }
            case "leftleg": {
                return MorphTarget.LeftLeg;
            }
            case "rightleg": {
                return MorphTarget.RightLeg;
            }
            case "cloak": {
                return MorphTarget.Cloak;
            }
        }
        return null;
    }

    @Nullable
    public Integer parseInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public Vec3 parseVector(String s) {
        try {
            String[] ss = s.split(",");
            double x = Double.parseDouble(ss[0]);
            double y = Double.parseDouble(ss[1]);
            double z = Double.parseDouble(ss[2]);
            return Vec3.func_72443_a((double)x, (double)y, (double)z);
        }
        catch (Exception e) {
            return null;
        }
    }
}

