/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.network.packets;

import java.io.DataInputStream;
import net.machinemuse.api.IModularItem;
import net.machinemuse.numina.general.MuseLogger;
import net.machinemuse.numina.network.MusePackager;
import net.machinemuse.numina.network.MusePacket;
import net.machinemuse.utils.MuseItemUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class MusePacketCosmeticInfo
extends MusePacket {
    EntityPlayer player;
    int itemSlot;
    String tagName;
    NBTTagCompound tagData;
    private static MusePacketCosmeticInfoPackager PACKAGERINSTANCE;

    public MusePacketCosmeticInfo(EntityPlayer player, int itemSlot, String tagName, NBTTagCompound tagData) {
        this.player = player;
        this.itemSlot = itemSlot;
        this.tagName = tagName;
        this.tagData = tagData;
    }

    public MusePackager packager() {
        return MusePacketCosmeticInfo.getPackagerInstance();
    }

    public void write() {
        this.writeInt(this.itemSlot);
        this.writeString(this.tagName);
        this.writeNBTTagCompound(this.tagData);
    }

    public void handleServer(EntityPlayerMP player) {
        ItemStack stack = player.field_71071_by.func_70301_a(this.itemSlot);
        if (this.tagName != null && stack != null && stack.func_77973_b() instanceof IModularItem) {
            NBTTagCompound itemTag = MuseItemUtils.getMuseItemTag(stack);
            NBTTagCompound renderTag = null;
            if (!itemTag.func_74764_b("render")) {
                renderTag = new NBTTagCompound();
                itemTag.func_74782_a("render", (NBTBase)renderTag);
            } else {
                renderTag = itemTag.func_74775_l("render");
            }
            if (this.tagData.func_82582_d()) {
                MuseLogger.logDebug((String)("Removing tag " + this.tagName));
                renderTag.func_82580_o(this.tagName);
            } else {
                MuseLogger.logDebug((String)("Adding tag " + this.tagName + " : " + this.tagData));
                renderTag.func_74782_a(this.tagName, (NBTBase)this.tagData);
            }
        }
    }

    public static MusePacketCosmeticInfoPackager getPackagerInstance() {
        if (PACKAGERINSTANCE == null) {
            PACKAGERINSTANCE = new MusePacketCosmeticInfoPackager();
        }
        return PACKAGERINSTANCE;
    }

    public static class MusePacketCosmeticInfoPackager
    extends MusePackager {
        public MusePacket read(DataInputStream datain, EntityPlayer player) {
            int itemSlot = this.readInt(datain);
            String tagName = this.readString(datain);
            NBTTagCompound tagData = this.readNBTTagCompound(datain);
            return new MusePacketCosmeticInfo(player, itemSlot, tagName, tagData);
        }
    }
}

