/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.network.packets;

import java.io.DataInputStream;
import java.util.HashSet;
import java.util.List;
import net.machinemuse.api.IPowerModule;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.numina.network.MusePackager;
import net.machinemuse.numina.network.MusePacket;
import net.machinemuse.numina.network.PacketSender;
import net.machinemuse.powersuits.common.Config;
import net.machinemuse.powersuits.network.packets.MusePacketInventoryRefresh;
import net.machinemuse.utils.MuseItemUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;

public class MusePacketSalvageModuleRequest
extends MusePacket {
    EntityPlayer player;
    int itemSlot;
    String moduleName;
    private static MusePacketSalvageModuleRequestPackager PACKAGERINSTANCE;

    public MusePacketSalvageModuleRequest(EntityPlayer player, int itemSlot, String moduleName) {
        this.player = player;
        this.itemSlot = itemSlot;
        this.moduleName = moduleName;
    }

    public MusePackager packager() {
        return MusePacketSalvageModuleRequest.getPackagerInstance();
    }

    public void write() {
        this.writeInt(this.itemSlot);
        this.writeString(this.moduleName);
    }

    public void handleServer(EntityPlayerMP player) {
        if (this.moduleName != null) {
            InventoryPlayer inventory = player.field_71071_by;
            ItemStack stack = player.field_71071_by.func_70301_a(this.itemSlot);
            IPowerModule moduleType = ModuleManager.getModule(this.moduleName);
            List<ItemStack> refund = moduleType.getInstallCost();
            if (ModuleManager.itemHasModule(stack, this.moduleName)) {
                HashSet<Integer> slots = new HashSet<Integer>();
                ModuleManager.removeModule(stack, this.moduleName);
                for (ItemStack refundItem : refund) {
                    slots.addAll(MuseItemUtils.giveOrDropItemWithChance(refundItem.func_77946_l(), (EntityPlayer)player, Config.getSalvageChance()));
                }
                slots.add(this.itemSlot);
                for (Integer slotiter : slots) {
                    MusePacketInventoryRefresh reply = new MusePacketInventoryRefresh((EntityPlayer)player, slotiter, inventory.func_70301_a(slotiter.intValue()));
                    PacketSender.sendTo((MusePacket)reply, (EntityPlayerMP)player);
                }
            }
        }
    }

    public static MusePacketSalvageModuleRequestPackager getPackagerInstance() {
        if (PACKAGERINSTANCE == null) {
            PACKAGERINSTANCE = new MusePacketSalvageModuleRequestPackager();
        }
        return PACKAGERINSTANCE;
    }

    public static class MusePacketSalvageModuleRequestPackager
    extends MusePackager {
        public MusePacket read(DataInputStream datain, EntityPlayer player) {
            int itemSlot = this.readInt(datain);
            String moduleName = this.readString(datain);
            return new MusePacketSalvageModuleRequest(player, itemSlot, moduleName);
        }
    }
}

