/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.tool;

import java.util.List;
import java.util.Objects;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IBlockBreakingModule;
import net.machinemuse.api.moduletrigger.IToggleableModule;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class PickaxeModule
extends PowerModuleBase
implements IBlockBreakingModule,
IToggleableModule {
    public static final String MODULE_PICKAXE = "Pickaxe";
    public static final String PICKAXE_HARVEST_SPEED = "Pickaxe Harvest Speed";
    public static final String PICKAXE_ENERGY_CONSUMPTION = "Pickaxe Energy Consumption";

    public PickaxeModule(List<IModularItem> validItems) {
        super(validItems);
        this.addInstallCost(new ItemStack(Items.field_151042_j, 3));
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.solenoid, 1));
        this.addBaseProperty(PICKAXE_ENERGY_CONSUMPTION, 50.0, "J");
        this.addBaseProperty(PICKAXE_HARVEST_SPEED, 8.0, "x");
        this.addTradeoffProperty("Overclock", PICKAXE_ENERGY_CONSUMPTION, 950.0);
        this.addTradeoffProperty("Overclock", PICKAXE_HARVEST_SPEED, 22.0);
    }

    @Override
    public String getCategory() {
        return "Tool";
    }

    @Override
    public String getDataName() {
        return MODULE_PICKAXE;
    }

    @Override
    public String getUnlocalizedName() {
        return "pickaxe";
    }

    @Override
    public String getDescription() {
        return "Picks are good for harder materials like stone and ore.";
    }

    @Override
    public String getTextureFile() {
        return "toolpick";
    }

    @Override
    public boolean canHarvestBlock(ItemStack stack, Block block, int meta, EntityPlayer player) {
        return PickaxeModule.harvestCheck(stack, block, meta, player);
    }

    @Override
    public boolean onBlockDestroyed(ItemStack stack, World world, Block block, int x, int y, int z, EntityPlayer player) {
        int meta = world.func_72805_g(x, y, z);
        if (this.canHarvestBlock(stack, block, meta, player)) {
            ElectricItemUtils.drainPlayerEnergy(player, ModuleManager.computeModularProperty(stack, PICKAXE_ENERGY_CONSUMPTION));
            return true;
        }
        return false;
    }

    @Override
    public void handleBreakSpeed(PlayerEvent.BreakSpeed event) {
        event.newSpeed = (float)((double)event.newSpeed * ModuleManager.computeModularProperty(event.entityPlayer.func_71045_bC(), PICKAXE_HARVEST_SPEED));
    }

    private static boolean istEffectiveHarvestTool(Block block, int metadata) {
        ItemStack emulatedTool = new ItemStack(Items.field_151035_b);
        String effectiveHarvestTool = block.getHarvestTool(metadata);
        if (Objects.equals(effectiveHarvestTool, "pickaxe")) {
            return block.getHarvestLevel(metadata) <= 2;
        }
        return effectiveHarvestTool == null && emulatedTool.func_150997_a(block) >= ((ItemTool)emulatedTool.func_77973_b()).func_150913_i().func_77998_b();
    }

    public static boolean harvestCheck(ItemStack stack, Block block, int meta, EntityPlayer player) {
        return PickaxeModule.istEffectiveHarvestTool(block, meta) && ElectricItemUtils.getPlayerEnergy(player) > ModuleManager.computeModularProperty(stack, PICKAXE_ENERGY_CONSUMPTION);
    }
}

