/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.tool;

import java.util.List;
import java.util.Objects;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IBlockBreakingModule;
import net.machinemuse.api.moduletrigger.IToggleableModule;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class ShovelModule
extends PowerModuleBase
implements IBlockBreakingModule,
IToggleableModule {
    public static final String MODULE_SHOVEL = "Shovel";
    public static final String SHOVEL_HARVEST_SPEED = "Shovel Harvest Speed";
    public static final String SHOVEL_ENERGY_CONSUMPTION = "Shovel Energy Consumption";

    public ShovelModule(List<IModularItem> validItems) {
        super(validItems);
        this.addInstallCost(new ItemStack(Items.field_151042_j, 3));
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.solenoid, 1));
        this.addBaseProperty(SHOVEL_ENERGY_CONSUMPTION, 50.0, "J");
        this.addBaseProperty(SHOVEL_HARVEST_SPEED, 8.0, "x");
        this.addTradeoffProperty("Overclock", SHOVEL_ENERGY_CONSUMPTION, 950.0);
        this.addTradeoffProperty("Overclock", SHOVEL_HARVEST_SPEED, 22.0);
    }

    @Override
    public String getCategory() {
        return "Tool";
    }

    @Override
    public String getDataName() {
        return MODULE_SHOVEL;
    }

    @Override
    public String getUnlocalizedName() {
        return "shovel";
    }

    @Override
    public String getDescription() {
        return "Shovels are good for soft materials like dirt and sand.";
    }

    @Override
    public String getTextureFile() {
        return "toolshovel";
    }

    private boolean istEffectiveHarvestTool(Block block, int metadata) {
        ItemStack emulatedTool = new ItemStack(Items.field_151037_a);
        if (emulatedTool.func_77973_b().canHarvestBlock(block, emulatedTool)) {
            return true;
        }
        String effectiveTool = block.getHarvestTool(metadata);
        if (effectiveTool == null && emulatedTool.func_150997_a(block) >= ((ItemTool)emulatedTool.func_77973_b()).func_150913_i().func_77998_b()) {
            return true;
        }
        return Objects.equals(effectiveTool, "shovel");
    }

    @Override
    public boolean canHarvestBlock(ItemStack stack, Block block, int meta, EntityPlayer player) {
        return this.istEffectiveHarvestTool(block, meta) && ElectricItemUtils.getPlayerEnergy(player) > ModuleManager.computeModularProperty(stack, SHOVEL_ENERGY_CONSUMPTION);
    }

    @Override
    public boolean onBlockDestroyed(ItemStack stack, World world, Block block, int x, int y, int z, EntityPlayer player) {
        int meta = world.func_72805_g(x, y, z);
        if (this.canHarvestBlock(stack, block, meta, player)) {
            ElectricItemUtils.drainPlayerEnergy(player, ModuleManager.computeModularProperty(stack, SHOVEL_ENERGY_CONSUMPTION));
            return true;
        }
        return false;
    }

    @Override
    public void handleBreakSpeed(PlayerEvent.BreakSpeed event) {
        event.newSpeed = (float)((double)event.newSpeed * ModuleManager.computeModularProperty(event.entityPlayer.func_71045_bC(), SHOVEL_HARVEST_SPEED));
    }
}

