/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.utils;

import java.util.List;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.powersuits.common.Config;
import net.machinemuse.utils.MuseItemUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;

public class MuseHeatUtils {
    public static final String MAXIMUM_HEAT = "Maximum Heat";
    public static final String CURRENT_HEAT = "Current Heat";
    public static final DamageSource overheatDamage = new OverheatDamage();

    public static double getPlayerHeat(EntityPlayer player) {
        double avail = 0.0;
        for (ItemStack stack : MuseItemUtils.getModularItemsInInventory(player)) {
            avail += MuseHeatUtils.getItemHeat(stack);
        }
        return avail;
    }

    public static double getMaxHeat(EntityPlayer player) {
        double avail = 0.0;
        for (ItemStack stack : MuseItemUtils.getModularItemsInInventory(player)) {
            avail += MuseHeatUtils.getMaxHeat(stack);
        }
        return avail + Config.baseMaxHeat();
    }

    public static double getMaxHeat(ItemStack stack) {
        return ModuleManager.computeModularProperty(stack, MAXIMUM_HEAT);
    }

    public static void coolPlayer(EntityPlayer player, double coolDegrees) {
        List<ItemStack> items = MuseItemUtils.getModularItemsInInventory(player);
        if (player.func_71039_bw()) {
            items.remove(player.func_71045_bC());
        }
        for (ItemStack stack : items) {
            double currHeat = MuseHeatUtils.getItemHeat(stack);
            if (coolDegrees > 0.0) {
                if (currHeat > coolDegrees) {
                    MuseHeatUtils.setItemHeat(stack, currHeat - coolDegrees);
                    return;
                }
                coolDegrees -= currHeat;
                MuseHeatUtils.setItemHeat(stack, 0.0);
                continue;
            }
            return;
        }
    }

    public static void heatPlayer(EntityPlayer player, double heatDegrees) {
        List<ItemStack> items = MuseItemUtils.getModularItemsInInventory(player);
        if (player.func_71039_bw()) {
            items.remove(player.func_71045_bC());
        }
        for (ItemStack stack : items) {
            double maxHeat;
            double currHeat = MuseHeatUtils.getItemHeat(stack);
            if (currHeat + heatDegrees < (maxHeat = MuseHeatUtils.getMaxHeat(stack))) {
                MuseHeatUtils.setItemHeat(stack, currHeat + heatDegrees);
                return;
            }
            heatDegrees -= maxHeat - currHeat;
            MuseHeatUtils.setItemHeat(stack, maxHeat);
        }
        double heatPerStack = heatDegrees / (double)items.size();
        for (ItemStack stack : items) {
            MuseHeatUtils.heatItem(stack, heatPerStack);
        }
    }

    public static double getItemHeat(ItemStack stack) {
        return MuseItemUtils.getDoubleOrZero(stack, CURRENT_HEAT);
    }

    public static void setItemHeat(ItemStack stack, double heat) {
        MuseItemUtils.setDoubleOrRemove(stack, CURRENT_HEAT, heat);
    }

    public static void heatItem(ItemStack stack, double value) {
        MuseHeatUtils.setItemHeat(stack, MuseHeatUtils.getItemHeat(stack) + value);
    }

    public static void coolItem(ItemStack stack, double value) {
        MuseHeatUtils.setItemHeat(stack, MuseHeatUtils.getItemHeat(stack) - value);
    }

    protected static final class OverheatDamage
    extends DamageSource {
        public OverheatDamage() {
            super("Overheat");
            this.func_76361_j();
            this.func_76348_h();
        }

        public boolean equals(DamageSource other) {
            return other.field_76373_n.equals(this.field_76373_n);
        }
    }
}

