/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.processor;

import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.IRecipeHandler;
import com.github.vfyjxf.nee.processor.IRecipeProcessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

public class VanillaRecipeProcessor
implements IRecipeProcessor {
    @Override
    @Nonnull
    public Set<String> getAllOverlayIdentifier() {
        return new HashSet<String>(Arrays.asList("brewing", "smelting", "fuel"));
    }

    @Override
    @Nonnull
    public String getRecipeProcessorId() {
        return "Vanilla";
    }

    @Override
    @Nonnull
    public List<PositionedStack> getRecipeInput(IRecipeHandler recipe, int recipeIndex, String identifier) {
        ArrayList<PositionedStack> recipeInputs = new ArrayList<PositionedStack>();
        if (this.getAllOverlayIdentifier().contains(identifier)) {
            recipeInputs.addAll(recipe.getIngredientStacks(recipeIndex));
            recipeInputs.addAll(recipe.getOtherStacks(recipeIndex));
        }
        return recipeInputs;
    }

    @Override
    @Nonnull
    public List<PositionedStack> getRecipeOutput(IRecipeHandler recipe, int recipeIndex, String identifier) {
        ArrayList<PositionedStack> recipeOutput = new ArrayList<PositionedStack>();
        if (this.getAllOverlayIdentifier().contains(identifier)) {
            recipeOutput.add(recipe.getResultStack(recipeIndex));
            return recipeOutput;
        }
        return recipeOutput;
    }
}

