/*
 * Decompiled with CFR 0.152.
 */
package neresources.api.messages;

import neresources.api.messages.ModifyMessage;
import neresources.api.messages.utils.MessageHelper;
import neresources.api.utils.DropItem;
import neresources.api.utils.Priority;
import neresources.utils.ReflectionHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class ModifyMobMessage
extends ModifyMessage {
    private Class clazz;
    private DropItem[] addDrops = new DropItem[0];
    private ItemStack[] removeDrops = new ItemStack[0];
    private boolean strict;
    private boolean witherSkeleton;

    public ModifyMobMessage(Class clazz, DropItem ... addDrops) {
        this(clazz, false, false, addDrops);
    }

    public ModifyMobMessage(Class clazz, boolean strict, DropItem ... addDrops) {
        this(clazz, strict, false, addDrops);
    }

    public ModifyMobMessage(Class clazz, boolean strict, boolean witherSkeleton, DropItem ... addDrops) {
        this(clazz, strict, witherSkeleton, Priority.SECOND, addDrops);
    }

    public ModifyMobMessage(Class clazz, Priority priority, DropItem ... addDrops) {
        this(clazz, false, false, priority, addDrops);
    }

    public ModifyMobMessage(Class clazz, boolean strict, Priority priority, DropItem ... addDrops) {
        this(clazz, strict, false, priority, addDrops);
    }

    public ModifyMobMessage(Class clazz, boolean strict, boolean witherSkeleton, Priority priority, DropItem ... addDrops) {
        this(clazz, strict, witherSkeleton, addDrops, new ItemStack[0], priority);
    }

    public ModifyMobMessage(Class clazz, ItemStack ... removeDrops) {
        this(clazz, false, false, removeDrops);
    }

    public ModifyMobMessage(Class clazz, boolean strict, ItemStack ... removeDrops) {
        this(clazz, strict, false, removeDrops);
    }

    public ModifyMobMessage(Class clazz, boolean strict, boolean witherSkeleton, ItemStack ... removeDrops) {
        this(clazz, strict, witherSkeleton, Priority.SECOND, removeDrops);
    }

    public ModifyMobMessage(Class clazz, Priority priority, ItemStack ... removeDrops) {
        this(clazz, false, false, priority, removeDrops);
    }

    public ModifyMobMessage(Class clazz, boolean strict, Priority priority, ItemStack ... removeDrops) {
        this(clazz, strict, false, priority, removeDrops);
    }

    public ModifyMobMessage(Class clazz, boolean strict, boolean witherSkeleton, Priority priority, ItemStack ... removeDrops) {
        this(clazz, strict, witherSkeleton, new DropItem[0], removeDrops, priority);
    }

    public ModifyMobMessage(Class clazz, DropItem[] addDrops, ItemStack[] removeDrops) {
        this(clazz, addDrops, removeDrops, Priority.SECOND);
    }

    public ModifyMobMessage(Class clazz, boolean strict, DropItem[] addDrops, ItemStack[] removeDrops) {
        this(clazz, strict, addDrops, removeDrops, Priority.SECOND);
    }

    public ModifyMobMessage(Class clazz, boolean strict, boolean witherSkeleton, DropItem[] addDrops, ItemStack[] removeDrops) {
        this(clazz, strict, witherSkeleton, addDrops, removeDrops, Priority.SECOND);
    }

    public ModifyMobMessage(Class clazz, DropItem[] addDrops, ItemStack[] removeDrops, Priority priority) {
        this(clazz, false, addDrops, removeDrops, priority);
    }

    public ModifyMobMessage(Class clazz, boolean strict, DropItem[] addDrops, ItemStack[] removeDrops, Priority priority) {
        this(clazz, strict, false, addDrops, removeDrops, priority);
    }

    public ModifyMobMessage(Class clazz, boolean strict, boolean witherSkeleton, DropItem[] addDrops, ItemStack[] removeDrops, Priority priority) {
        this(clazz, strict, witherSkeleton, addDrops, removeDrops, priority, priority);
    }

    public ModifyMobMessage(Class clazz, boolean strict, boolean witherSkeleton, DropItem[] addDrops, ItemStack[] removeDrops, Priority addPriority, Priority removePriority) {
        super(addPriority, removePriority);
        this.initialize(clazz, strict, witherSkeleton, addDrops, removeDrops);
    }

    @Override
    public boolean hasAdd() {
        return this.addDrops.length > 0;
    }

    @Override
    public boolean hasRemove() {
        return this.removeDrops.length > 0;
    }

    public Class getFilterClass() {
        return this.clazz;
    }

    public DropItem[] getAddDrops() {
        return this.addDrops;
    }

    public ItemStack[] getRemoveDrops() {
        return this.removeDrops;
    }

    public boolean isWither() {
        return this.witherSkeleton;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public ModifyMobMessage(NBTTagCompound tagCompound) {
        super(tagCompound);
        this.initialize(ReflectionHelper.findClass(tagCompound.func_74779_i("name")), tagCompound.func_74767_n("strict"), tagCompound.func_74767_n("wither"), MessageHelper.getDropItems(tagCompound, "addDrops"), MessageHelper.getItemStacks(tagCompound, "removeDrops"));
    }

    private void initialize(Class clazz, boolean strict, boolean witherSkeleton, DropItem[] addDrops, ItemStack[] removeDrops) {
        this.clazz = clazz;
        this.strict = strict;
        this.witherSkeleton = witherSkeleton;
        this.addDrops = addDrops;
        this.removeDrops = removeDrops;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.func_74778_a("name", this.clazz.getName());
        tagCompound.func_74757_a("strict", this.strict);
        tagCompound.func_74757_a("wither", this.witherSkeleton);
        tagCompound.func_74782_a("addDrops", (NBTBase)MessageHelper.getDropItemList(this.addDrops));
        tagCompound.func_74782_a("removeDrops", (NBTBase)MessageHelper.getItemStackList(this.removeDrops));
        return tagCompound;
    }

    public void setWither(boolean wither) {
        this.witherSkeleton = wither;
    }

    @Override
    public boolean isValid() {
        return this.clazz != null && (this.hasAdd() || this.hasRemove());
    }
}

