/*
 * Decompiled with CFR 0.152.
 */
package neresources.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import neresources.api.utils.PlantDrop;
import neresources.entries.PlantEntry;
import neresources.reference.Resources;
import neresources.registry.PlantRegistry;
import neresources.utils.TranslationHelper;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class NEIPlantHandler
extends TemplateRecipeHandler {
    private static final int GRASS_X = 75;
    private static final int GRASS_Y = 5;
    private static final int OUTPUT_X = 2;
    private static final int OUTPUT_SCALE = 20;
    private static final int OUTPUT_Y = 51;
    private static final int INPUT_ARROW_Y = 20;

    public String getGuiTexture() {
        return Resources.Gui.Nei.PLANT.toString();
    }

    public String getRecipeName() {
        return TranslationHelper.translateToLocal("ner.plant.title");
    }

    public int recipiesPerPage() {
        return 1;
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)5, (int)11, (int)166, (int)130);
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(75, 20, 16, 30), "neresources.plant", new Object[]{new Object()}));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("neresources.plant")) {
            for (PlantEntry entry : PlantRegistry.getInstance().getAllPlants()) {
                this.arecipes.add(new CachedPlant(entry));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (ingredients.length == 0) {
            return;
        }
        if (ingredients[0] instanceof ItemStack) {
            ItemStack ingredient = (ItemStack)ingredients[0];
            if (PlantRegistry.getInstance().contains(ingredient)) {
                this.arecipes.add(new CachedPlant(PlantRegistry.getInstance().getEntry(ingredient)));
            }
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public class CachedPlant
    extends TemplateRecipeHandler.CachedRecipe {
        private PlantEntry plantEntry;

        public CachedPlant(PlantEntry entry) {
            super((TemplateRecipeHandler)NEIPlantHandler.this);
            this.plantEntry = entry;
        }

        public PositionedStack getResult() {
            return new PositionedStack((Object)this.plantEntry.getPlant(), 75, 5);
        }

        public List<PositionedStack> getOtherStacks() {
            ArrayList<PositionedStack> list = new ArrayList<PositionedStack>();
            int xOffset = 0;
            int yOffset = 0;
            for (PlantDrop plantDrop : this.plantEntry.getDrops()) {
                list.add(new PositionedStack((Object)plantDrop.getDrop(), 2 + xOffset, 51 + yOffset));
                if ((xOffset += 20) <= 147) continue;
                xOffset = 0;
                yOffset += 20;
            }
            return list;
        }
    }
}

