/*
 * Decompiled with CFR 0.152.
 */
package neresources.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import neresources.api.messages.ModifyOreMessage;
import neresources.api.messages.RegisterOreMessage;
import neresources.api.utils.Priority;
import neresources.entries.OreMatchEntry;
import neresources.registry.MessageRegistry;
import neresources.utils.MapKeys;
import net.minecraft.item.ItemStack;

public class OreRegistry {
    private static Map<Integer, OreMatchEntry> matchEntryMap = new LinkedHashMap<Integer, OreMatchEntry>();
    private static Map<String, Set<Integer>> dropMap = new LinkedHashMap<String, Set<Integer>>();

    public static void clear() {
        matchEntryMap = new LinkedHashMap<Integer, OreMatchEntry>();
        dropMap = new LinkedHashMap<String, Set<Integer>>();
    }

    public static void registerOre(RegisterOreMessage message) {
        String key = MapKeys.getKey(message.getOre());
        if (key == null) {
            return;
        }
        if (dropMap.containsKey(key)) {
            Set<Integer> hashCodes = dropMap.get(key);
            boolean matched = false;
            for (int hashCode : hashCodes) {
                if (!matchEntryMap.get(hashCode).add(message)) continue;
                matched = true;
                break;
            }
            if (!matched) {
                int newHash = OreRegistry.addNewOre(key, message);
                for (int hashCode : hashCodes) {
                    if (hashCode == newHash) continue;
                    matchEntryMap.get(newHash).add(matchEntryMap.get(hashCode));
                }
            }
        } else {
            OreRegistry.addNewOre(key, message);
        }
        ItemStack[] drops = message.getDrops();
        if (drops == null || drops.length == 0) {
            return;
        }
        MessageRegistry.addMessage(new ModifyOreMessage(message.getOre(), Priority.FIRST, drops));
    }

    private static int addNewOre(String key, RegisterOreMessage message) {
        OreMatchEntry newMatch = new OreMatchEntry(message);
        int hashCode = newMatch.hashCode();
        Set<Object> hashSet = dropMap.containsKey(key) ? dropMap.get(key) : new LinkedHashSet();
        hashSet.add(hashCode);
        dropMap.put(key, hashSet);
        matchEntryMap.put(hashCode, newMatch);
        return hashCode;
    }

    public static List<OreMatchEntry> getOres() {
        ArrayList<OreMatchEntry> result = new ArrayList<OreMatchEntry>();
        TreeSet<Integer> addedCodes = new TreeSet<Integer>();
        for (Set<Integer> hashCodes : dropMap.values()) {
            for (int hashCode : hashCodes) {
                if (addedCodes.contains(hashCode)) continue;
                addedCodes.add(hashCode);
                result.add(matchEntryMap.get(hashCode));
            }
        }
        return result;
    }

    public static List<OreMatchEntry> getRegistryMatches(ItemStack itemStack) {
        String key = MapKeys.getKey(itemStack);
        ArrayList<OreMatchEntry> result = new ArrayList<OreMatchEntry>();
        if (dropMap.containsKey(key)) {
            for (Integer hashCode : dropMap.get(key)) {
                result.add(matchEntryMap.get(hashCode));
            }
        }
        return result;
    }

    public static boolean removeDrops(ModifyOreMessage oreMod) {
        if (oreMod.getRemoveDrops() == null) {
            return true;
        }
        String oreKey = MapKeys.getKey(oreMod.getOre());
        if (oreKey == null || !dropMap.containsKey(oreKey) || dropMap.get(oreKey).isEmpty()) {
            return false;
        }
        for (ItemStack drop : oreMod.getRemoveDrops()) {
            String dropKey = MapKeys.getKey(drop);
            if (dropKey == null || !dropMap.containsKey(dropKey)) continue;
            Set<Integer> hashSet = dropMap.get(oreKey);
            dropMap.get(dropKey).removeAll(hashSet);
            for (int hashCode : hashSet) {
                matchEntryMap.get(hashCode).removeDrop(drop);
            }
        }
        return true;
    }

    public static boolean addDrops(ModifyOreMessage oreMod) {
        if (oreMod.getAddDrops() == null) {
            return true;
        }
        String oreKey = MapKeys.getKey(oreMod.getOre());
        if (oreKey == null || !dropMap.containsKey(oreKey)) {
            return false;
        }
        for (ItemStack drop : oreMod.getAddDrops()) {
            String dropKey = MapKeys.getKey(drop);
            if (dropKey == null) continue;
            Set<Object> hashSet = dropMap.containsKey(dropKey) ? dropMap.get(dropKey) : new LinkedHashSet();
            for (int hashCode : dropMap.get(oreKey)) {
                matchEntryMap.get(hashCode).addDrop(drop);
            }
            hashSet.addAll((Collection)dropMap.get(oreKey));
            dropMap.put(dropKey, hashSet);
        }
        return true;
    }

    public static void addOreLink(String key, String oreKey) {
        if (dropMap.containsKey(oreKey)) {
            dropMap.put(key, dropMap.get(oreKey));
        }
    }
}

