/*
 * Decompiled with CFR 0.152.
 */
package ru.stepan1404.notifications;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLEventChannel;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.command.ICommand;
import ru.stepan1404.notifications.commands.CommandNotifications;
import ru.stepan1404.notifications.config.Config;
import ru.stepan1404.notifications.event.RenderEvent;
import ru.stepan1404.notifications.gui.NotificationGui;
import ru.stepan1404.notifications.model.Notification;
import ru.stepan1404.notifications.network.NotificationMessage;
import ru.stepan1404.notifications.network.NotificationPluginMessage;
import ru.stepan1404.notifications.task.NotificationTask;
import ru.stepan1404.notifications.utils.Events;

@Mod(modid="lp_notifications", name="LetsPlay Notification", version="1.0.0")
public class NotificationsMod {
    @Mod.Instance
    private static NotificationsMod mod;
    private Config config;
    private SimpleNetworkWrapper network;
    private File configFile;

    public static NotificationsMod getMod() {
        return mod;
    }

    public Config getConfig() {
        return this.config;
    }

    public SimpleNetworkWrapper getNetwork() {
        return this.network;
    }

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent event) {
        this.initModules(event.getSuggestedConfigurationFile());
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            Events.registerEvent(new RenderEvent());
            Events.registerEvent(this);
            FMLEventChannel ch = NetworkRegistry.INSTANCE.newEventDrivenChannel("plNotify");
            ch.register((Object)this);
        }
    }

    @SubscribeEvent
    public void onClientPacket(FMLNetworkEvent.ClientCustomPacketEvent event) {
        ByteBuf buf;
        String[] message;
        if (event.packet.channel().equals("plNotify") && (message = new String((buf = event.packet.payload()).array()).split(";"))[0].equalsIgnoreCase("plugin")) {
            String letterType = message[1];
            int lifetime = Integer.parseInt(message[2]);
            String messageText = message[3];
            Notification model = new Notification(letterType, messageText, lifetime);
            NotificationGui.getInstance().getNotificationList().add(model);
        }
    }

    private void initModules(File file) {
        this.configFile = file;
        this.network = NetworkRegistry.INSTANCE.newSimpleChannel("lp_notifications");
        this.network.registerMessage(NotificationMessage.class, NotificationMessage.class, 0, Side.CLIENT);
        this.network.registerMessage(NotificationPluginMessage.class, NotificationPluginMessage.class, 1, Side.CLIENT);
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandNotifications());
    }

    @Mod.EventHandler
    public void onServerStarted(FMLServerStartedEvent event) {
        this.config = new Config(this.configFile);
        this.config.launch();
        Timer timer = new Timer();
        timer.scheduleAtFixedRate((TimerTask)new NotificationTask(), 0L, (long)(NotificationsMod.getMod().getConfig().getDelay() * 1000));
    }
}

