/*
 * Decompiled with CFR 0.152.
 */
package ru.stepan1404.notifications.model;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Color;
import ru.stepan1404.notifications.event.RenderEvent;
import ru.stepan1404.notifications.render.Area;

public class Notification {
    private static final int maxTranslateX = 144;
    private int translateX;
    private Area area;
    private long lifetime;
    private long lifestart;
    private NotificationType type;
    private List<String> message;
    private boolean showed;

    public Notification(String typeLetter, String message, int lifetime) {
        Minecraft minecraft = Minecraft.func_71410_x();
        FontRenderer fonts = minecraft.field_71466_p;
        ScaledResolution resolution = new ScaledResolution(minecraft, minecraft.field_71443_c, minecraft.field_71440_d);
        this.type = NotificationType.getTypeByLetter(typeLetter);
        this.message = fonts.func_78271_c(message, 118);
        this.lifetime = lifetime * 1000;
        this.lifestart = System.currentTimeMillis();
        int height = (fonts.field_78288_b + 2) * this.message.size() + 4 > 20 ? (fonts.field_78288_b + 2) * this.message.size() + 4 : 20;
        this.area = new Area(resolution.func_78326_a(), 8, 144, height);
    }

    public void draw() {
        if (RenderEvent.isMinecraftResized()) {
            Minecraft minecraft = Minecraft.func_71410_x();
            ScaledResolution resolution = new ScaledResolution(minecraft, minecraft.field_71443_c, minecraft.field_71440_d);
            this.area = new Area(resolution.func_78326_a(), this.area.getY(), this.area.getWidth(), this.area.getHeight());
        }
        if (System.currentTimeMillis() > this.lifetime + this.lifestart) {
            if (this.translateX > 0) {
                this.translateX -= 4;
                this.drawNote();
            } else {
                this.showed = true;
            }
        } else {
            if (this.translateX < 144) {
                this.translateX += 4;
            }
            this.drawNote();
        }
    }

    private void drawNote() {
        int color = Integer.MIN_VALUE;
        GL11.glTranslatef((float)(-this.translateX), (float)0.0f, (float)0.0f);
        Gui.func_73734_a((int)this.area.getX(), (int)this.area.getY(), (int)(this.area.getWidth() + this.area.getX()), (int)(this.area.getHeight() + this.area.getY()), (int)color);
        Gui.func_73734_a((int)this.area.getX(), (int)this.area.getY(), (int)(this.area.getX() + 4), (int)(this.area.getHeight() + this.area.getY()), (int)this.type.getColorInt());
        GL11.glEnable((int)32826);
        RenderHelper.func_74520_c();
        RenderItem.getInstance().func_82406_b(Minecraft.func_71410_x().field_71466_p, Minecraft.func_71410_x().func_110434_K(), this.type.itemStack, this.area.getX() + 6, this.area.getY() + this.area.getHeight() / 2 - 8);
        RenderItem.getInstance().func_77021_b(Minecraft.func_71410_x().field_71466_p, Minecraft.func_71410_x().func_110434_K(), this.type.itemStack, this.area.getX() + 6, this.area.getY() + this.area.getHeight() / 2 - 8);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)32826);
        for (int i = 0; i < this.message.size(); ++i) {
            String s = this.message.get(i);
            int j = 0;
            if (this.area.getHeight() == 20) {
                j += 3;
            }
            Minecraft.func_71410_x().field_71466_p.func_78261_a(s, this.area.getX() + 24, 2 + (i + 1) * (Minecraft.func_71410_x().field_71466_p.field_78288_b + 2) + j, 0xFFFFFF);
        }
        GL11.glTranslatef((float)this.translateX, (float)0.0f, (float)0.0f);
    }

    public Area getArea() {
        return this.area;
    }

    public boolean isShowed() {
        return this.showed;
    }

    public static enum NotificationType {
        WARNING(new ItemStack(Items.field_151129_at), new Color(204, 32, 2, 140)),
        INFO(new ItemStack(Items.field_151008_G), new Color(8, 149, 214, 140)),
        SERVER(new ItemStack(Items.field_151166_bC), new Color(83, 63, 175, 140)),
        SALE(new ItemStack(Items.field_151045_i), new Color(156, 20, 224, 140));

        private ItemStack itemStack;
        private Color color;

        private NotificationType(ItemStack itemStack, Color color) {
            this.itemStack = itemStack;
            this.color = color;
        }

        public int getColorInt() {
            return (this.color.getAlpha() << 24) + (this.color.getRed() << 16) + (this.color.getGreen() << 8) + this.color.getBlue();
        }

        public static NotificationType getTypeByLetter(String letter) {
            if (letter.equalsIgnoreCase("W")) {
                return WARNING;
            }
            if (letter.equalsIgnoreCase("S")) {
                return SALE;
            }
            if (letter.equalsIgnoreCase("B")) {
                return SERVER;
            }
            return INFO;
        }

        public ItemStack getItemStack() {
            return this.itemStack;
        }

        public Color getColor() {
            return this.color;
        }
    }
}

