/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.network;

import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.machinemuse.numina.general.MuseLogger;
import net.machinemuse.numina.network.MusePackager;
import net.machinemuse.numina.network.MusePacketHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;

public abstract class MusePacket {
    private final ByteBuf bytes = Unpooled.buffer();
    private final DataOutputStream dataout = new DataOutputStream((OutputStream)new ByteBufOutputStream(this.bytes));

    public abstract MusePackager packager();

    public abstract void write();

    public ByteBuf bytes() {
        return this.bytes;
    }

    public DataOutputStream dataout() {
        return this.dataout;
    }

    public FMLProxyPacket getFMLProxyPacket() throws IOException {
        this.dataout.writeInt((Integer)MusePacketHandler.packagers.inverse().get(this.packager()));
        this.write();
        return new FMLProxyPacket(this.bytes, MusePacketHandler.networkChannelName);
    }

    public MusePacket getPacket131() {
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public void handleClient(EntityPlayer player) {
    }

    public void handleServer(EntityPlayerMP player) {
    }

    public void writeInt(int i) {
        try {
            this.dataout.writeInt(i);
        }
        catch (IOException exception) {
            MuseLogger.logException("PROBLEM WRITING DATA TO PACKET:", exception);
        }
    }

    public void writeIntArray(int[] data) {
        try {
            this.dataout.writeInt(data.length);
            for (int k : data) {
                this.dataout.writeInt(k);
            }
        }
        catch (IOException exception) {
            MuseLogger.logException("PROBLEM WRITING DATA TO PACKET:", exception);
        }
    }

    public void writeBoolean(boolean b) {
        try {
            this.dataout.writeBoolean(b);
        }
        catch (IOException exception) {
            MuseLogger.logException("PROBLEM WRITING DATA TO PACKET:", exception);
        }
    }

    public void writeDouble(double i) {
        try {
            this.dataout.writeDouble(i);
        }
        catch (IOException exception) {
            MuseLogger.logException("PROBLEM WRITING DATA TO PACKET:", exception);
        }
    }

    public void writeItemStack(ItemStack stack) {
        try {
            if (stack == null) {
                this.dataout.writeShort(-1);
            } else {
                NBTTagCompound nbt = new NBTTagCompound();
                stack.func_77955_b(nbt);
                this.writeNBTTagCompound(nbt);
            }
        }
        catch (IOException exception) {
            MuseLogger.logException("PROBLEM WRITING DATA TO PACKET:", exception);
        }
    }

    public void writeNBTTagCompound(NBTTagCompound nbt) {
        try {
            if (nbt == null) {
                this.dataout.writeShort(-1);
            } else {
                byte[] compressednbt = CompressedStreamTools.func_74798_a((NBTTagCompound)nbt);
                this.dataout.writeShort((short)compressednbt.length);
                this.dataout.write(compressednbt);
            }
        }
        catch (IOException exception) {
            MuseLogger.logException("PROBLEM WRITING DATA TO PACKET:", exception);
        }
    }

    public void writeString(String string) {
        try {
            this.dataout.writeUTF(string);
        }
        catch (IOException exception) {
            MuseLogger.logException("PROBLEM WRITING DATA TO PACKET:", exception);
        }
    }
}

