/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.network;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import net.machinemuse.numina.general.MuseLogger;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;

public class RichInputStream {
    public static DataInputStream in;

    private RichInputStream(DataInputStream in) {
        RichInputStream.in = in;
    }

    public static RichInputStream toRichStream(DataInputStream in) {
        return new RichInputStream(in);
    }

    public int[] readIntArray() {
        ArrayList<Integer> integerArrayList = new ArrayList<Integer>();
        try {
            int arraySize = in.readInt();
            for (int k = 0; k < arraySize; ++k) {
                integerArrayList.add(in.readInt());
            }
            int[] intArray = new int[integerArrayList.size()];
            for (int i = 0; i < integerArrayList.size(); ++i) {
                intArray[i] = (Integer)integerArrayList.get(i);
            }
            return intArray;
        }
        catch (IOException e) {
            MuseLogger.logException("PROBLEM READING DATA FROM PACKET D:", e);
            return new int[0];
        }
    }

    public ItemStack readItemStack() {
        NBTTagCompound tag = this.readNBTTagCompound();
        return tag == null ? null : ItemStack.func_77949_a((NBTTagCompound)tag);
    }

    public NBTTagCompound readNBTTagCompound() {
        short length = 0;
        try {
            length = in.readShort();
            return length != -1 ? CompressedStreamTools.func_74796_a((InputStream)in) : null;
        }
        catch (IOException e) {
            MuseLogger.logException("PROBLEM READING DATA FROM PACKET D:", e);
            return null;
        }
    }

    public String readString() {
        try {
            return in.readUTF();
        }
        catch (IOException e) {
            MuseLogger.logException("PROBLEM READING DATA FROM PACKET D:", e);
            return null;
        }
    }
}

