/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.recipe;

import cpw.mods.fml.common.registry.GameRegistry;
import net.machinemuse.numina.basemod.NuminaConfig;
import net.machinemuse.numina.general.MuseLogger;
import net.machinemuse.numina.recipe.IItemMatcher;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;

public class SimpleItemMatcher
implements IItemMatcher {
    public Integer meta;
    public String unlocalizedName;
    public String oredictName;
    public String registryName;
    public String itemStackName;
    public String nbtString;

    @Override
    public boolean matchesItem(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack.func_77973_b() == null) {
            return false;
        }
        if (this.meta != null && this.meta.intValue() != stack.func_77960_j()) {
            return false;
        }
        if (this.unlocalizedName != null) {
            NuminaConfig.warnOnce("WARNING: unlocalizedName is deprecated; please use registryName or itemStackName instead!");
            if (!this.unlocalizedName.equals(stack.func_77973_b().func_77667_c(stack))) {
                return false;
            }
        }
        if (this.oredictName != null) {
            boolean found = false;
            for (ItemStack ore : OreDictionary.getOres((String)this.oredictName)) {
                if (ore.func_77973_b() != stack.func_77973_b() || ore.func_77960_j() != stack.func_77960_j()) continue;
                found = true;
            }
            if (!found) {
                return false;
            }
        }
        if (this.registryName != null) {
            String[] names = this.registryName.split(":");
            Item item = GameRegistry.findItem((String)names[0], (String)names[1]);
            if (item == null) {
                MuseLogger.logError("Item " + this.registryName + " not found in registry for recipe.");
                return false;
            }
            if (item != stack.func_77973_b()) {
                return false;
            }
        }
        if (this.itemStackName != null) {
            String[] names = this.itemStackName.split(":");
            ItemStack compareStack = GameRegistry.findItemStack((String)names[0], (String)names[1], (int)1);
            if (compareStack == null) {
                MuseLogger.logError("ItemStack " + this.itemStackName + " not found in registry for recipe.");
                return false;
            }
            if (stack.func_77960_j() != compareStack.func_77960_j()) {
                return false;
            }
            if (stack.func_77973_b() != compareStack.func_77973_b()) {
                return false;
            }
            if (!stack.func_77978_p().equals((Object)compareStack.func_77978_p())) {
                return false;
            }
        }
        if (this.nbtString != null) {
            try {
                NBTTagCompound nbt = (NBTTagCompound)JsonToNBT.func_150315_a((String)this.nbtString);
                if (!nbt.equals((Object)stack.func_77978_p())) {
                    return false;
                }
            }
            catch (Exception e) {
                MuseLogger.logException("Bad NBT string in item!", e);
                return false;
            }
        }
        return true;
    }

    public SimpleItemMatcher copy() {
        SimpleItemMatcher copy = new SimpleItemMatcher();
        copy.meta = this.meta;
        copy.unlocalizedName = this.unlocalizedName;
        copy.oredictName = this.unlocalizedName;
        return copy;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SimpleItemMatcher)) {
            return false;
        }
        SimpleItemMatcher other = (SimpleItemMatcher)obj;
        if (!this.compareInteger(this.meta, other.meta)) {
            return false;
        }
        if (!this.compareString(this.unlocalizedName, other.unlocalizedName)) {
            return false;
        }
        if (!this.compareString(this.oredictName, other.oredictName)) {
            return false;
        }
        if (!this.compareString(this.registryName, other.registryName)) {
            return false;
        }
        if (!this.compareString(this.itemStackName, other.itemStackName)) {
            return false;
        }
        return this.compareString(this.nbtString, other.nbtString);
    }

    private boolean compareInteger(Integer a, Integer b) {
        if (a == null && b == null) {
            return true;
        }
        return a != null && b != null && a.intValue() == b.intValue();
    }

    private boolean compareString(String a, String b) {
        if (a == null && b == null) {
            return true;
        }
        return a != null && b != null && a.equals(b);
    }
}

