/*
 * Decompiled with CFR 0.152.
 */
package com.gamerforea.packetunlimiter.asm;

import com.gamerforea.packetunlimiter.CoreMod;
import com.gamerforea.packetunlimiter.asm.ASMHelper;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class ASMTransformer
implements IClassTransformer,
Opcodes {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (transformedName.equals("net.minecraft.network.PacketBuffer")) {
            return ASMTransformer.patchPacketBuffer(basicClass);
        }
        return basicClass;
    }

    private static byte[] patchPacketBuffer(byte[] basicClass) {
        ClassNode cNode = new ClassNode();
        new ClassReader(basicClass).accept((ClassVisitor)cNode, 0);
        String writeNbt = ASMHelper.getMethod("net.minecraft.network.PacketBuffer.writeNBTTagCompoundToBuffer");
        String readNbt = ASMHelper.getMethod("net.minecraft.network.PacketBuffer.readNBTTagCompoundFromBuffer");
        for (MethodNode mNode : cNode.methods) {
            InsnList insn;
            if (mNode.name.equals(writeNbt) && mNode.desc.equals("(Lnet/minecraft/nbt/NBTTagCompound;)V")) {
                if (CoreMod.writeNbtLimit) continue;
                insn = new InsnList();
                insn.add((AbstractInsnNode)new VarInsnNode(25, 0));
                insn.add((AbstractInsnNode)new VarInsnNode(25, 1));
                insn.add((AbstractInsnNode)new MethodInsnNode(184, "com/gamerforea/packetunlimiter/asm/PacketBufferPatch", "writeNBTTagCompoundToBuffer", "(Lnet/minecraft/network/PacketBuffer;Lnet/minecraft/nbt/NBTTagCompound;)V", false));
                insn.add((AbstractInsnNode)new InsnNode(177));
                mNode.instructions = insn;
                continue;
            }
            if (!mNode.name.equals(readNbt) || !mNode.desc.equals("()Lnet/minecraft/nbt/NBTTagCompound;") || CoreMod.readNbtLimit) continue;
            insn = new InsnList();
            insn.add((AbstractInsnNode)new VarInsnNode(25, 0));
            insn.add((AbstractInsnNode)new MethodInsnNode(184, "com/gamerforea/packetunlimiter/asm/PacketBufferPatch", "readNBTTagCompoundFromBuffer", "(Lnet/minecraft/network/PacketBuffer;)Lnet/minecraft/nbt/NBTTagCompound;", false));
            insn.add((AbstractInsnNode)new InsnNode(176));
            mNode.instructions = insn;
        }
        ClassWriter cWriter = new ClassWriter(1);
        cNode.accept((ClassVisitor)cWriter);
        return cWriter.toByteArray();
    }
}

