/*
 * Decompiled with CFR 0.152.
 */
package com.gamerforea.packetunlimiter.asm;

import com.gamerforea.packetunlimiter.CoreMod;
import cpw.mods.fml.relauncher.FMLRelaunchLog;
import java.io.IOException;
import java.util.Arrays;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import org.apache.commons.lang3.ArrayUtils;

public final class PacketBufferPatch {
    public static void writeNBTTagCompoundToBuffer(PacketBuffer buf, NBTTagCompound nbt) throws IOException {
        if (nbt == null) {
            buf.writeShort(-1);
        } else {
            byte[] arr = CompressedStreamTools.func_74798_a((NBTTagCompound)nbt);
            if (arr.length < Short.MAX_VALUE) {
                buf.writeShort(arr.length);
                buf.writeBytes(arr);
            } else {
                byte[] arr1 = Arrays.copyOfRange(arr, 0, Short.MAX_VALUE);
                buf.writeShort(arr1.length);
                buf.writeBytes(arr1);
                byte[] arr2 = arr.length == Short.MAX_VALUE ? new byte[]{} : Arrays.copyOfRange(arr, Short.MAX_VALUE, arr.length);
                buf.writeInt(arr2.length);
                buf.writeBytes(arr2);
                if (CoreMod.bigPacketWarning) {
                    FMLRelaunchLog.warning((String)("[PacketUnlimiter] Sending packet with size " + arr.length + " bytes."), (Object[])new Object[0]);
                }
            }
        }
    }

    public static NBTTagCompound readNBTTagCompoundFromBuffer(PacketBuffer buf) throws IOException {
        short length = buf.readShort();
        if (length < 0) {
            return null;
        }
        byte[] arr = new byte[length];
        buf.readBytes(arr);
        if (length == Short.MAX_VALUE) {
            int length1 = buf.readInt();
            byte[] arr1 = new byte[length1];
            buf.readBytes(arr1);
            arr = ArrayUtils.addAll((byte[])arr, (byte[])arr1);
        }
        return CompressedStreamTools.func_152457_a((byte[])arr, (NBTSizeTracker)new NBTSizeTracker(CoreMod.unpackNbtLimit ? 0x200000L : Long.MAX_VALUE));
    }
}

