/*
 * Decompiled with CFR 0.152.
 */
package physica.api.core.abstraction;

import cofh.api.energy.IEnergyConnection;
import cofh.api.energy.IEnergyContainerItem;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.oredict.OreDictionary;
import physica.api.core.abstraction.Face;

public class AbstractionLayer {

    public static class Electricity {
        public static boolean isElectric(TileEntity tile) {
            return tile instanceof IEnergyConnection;
        }

        public static boolean isElectricReceiver(TileEntity tile) {
            return tile instanceof IEnergyReceiver;
        }

        public static boolean isElectricProvider(TileEntity tile) {
            return tile instanceof IEnergyProvider;
        }

        public static boolean canConnectElectricity(TileEntity tile, Face from) {
            if (Electricity.isElectric(tile)) {
                return ((IEnergyConnection)tile).canConnectEnergy(from.Forge());
            }
            return false;
        }

        public static int extractElectricity(TileEntity tile, Face from, int maxExtract, boolean simulate) {
            if (Electricity.isElectricProvider(tile) && Electricity.canConnectElectricity(tile, from)) {
                return ((IEnergyProvider)tile).extractEnergy(from.Forge(), maxExtract, simulate);
            }
            return 0;
        }

        public static int receiveElectricity(TileEntity tile, Face from, int maxReceive, boolean simulate) {
            if (Electricity.isElectricReceiver(tile) && Electricity.canConnectElectricity(tile, from)) {
                return ((IEnergyReceiver)tile).receiveEnergy(from.Forge(), maxReceive, simulate);
            }
            return 0;
        }

        public static boolean canInputElectricityNow(TileEntity tile, Face from) {
            if (Electricity.receiveElectricity(tile, from, Integer.MAX_VALUE, true) > 0) {
                return true;
            }
            if (Electricity.isElectricReceiver(tile)) {
                return ((IEnergyReceiver)tile).getEnergyStored(from.Forge()) < ((IEnergyReceiver)tile).getMaxEnergyStored(from.Forge());
            }
            return false;
        }

        public static int getElectricityStored(TileEntity tile, Face from) {
            if (Electricity.isElectricReceiver(tile)) {
                return ((IEnergyReceiver)tile).getEnergyStored(from.Forge());
            }
            if (Electricity.isElectricProvider(tile)) {
                return ((IEnergyProvider)tile).getEnergyStored(from.Forge());
            }
            return -1;
        }

        public static int getElectricCapacity(TileEntity tile, Face from) {
            if (Electricity.isElectricReceiver(tile)) {
                return ((IEnergyReceiver)tile).getMaxEnergyStored(from.Forge());
            }
            if (Electricity.isElectricProvider(tile)) {
                return ((IEnergyProvider)tile).getMaxEnergyStored(from.Forge());
            }
            return -1;
        }

        public static boolean isItemElectric(ItemStack stack) {
            return stack != null && stack.func_77973_b() instanceof IEnergyContainerItem;
        }

        public static int getElectricityStored(ItemStack stack) {
            if (Electricity.isItemElectric(stack)) {
                return ((IEnergyContainerItem)stack.func_77973_b()).getEnergyStored(stack);
            }
            return -1;
        }

        public static int getElectricCapacity(ItemStack stack) {
            if (Electricity.isItemElectric(stack)) {
                return ((IEnergyContainerItem)stack.func_77973_b()).getMaxEnergyStored(stack);
            }
            return -1;
        }

        public static int extractElectricity(ItemStack stack, int maxExtract, boolean simulate) {
            if (Electricity.isItemElectric(stack)) {
                return ((IEnergyContainerItem)stack.func_77973_b()).extractEnergy(stack, maxExtract, simulate);
            }
            return 0;
        }

        public static int receiveElectricity(ItemStack stack, int maxExtract, boolean simulate) {
            if (Electricity.isItemElectric(stack)) {
                return ((IEnergyContainerItem)stack.func_77973_b()).receiveEnergy(stack, maxExtract, simulate);
            }
            return 0;
        }
    }

    public static class Registering {
        public static Block registerBlock(Block block, String name) {
            return GameRegistry.registerBlock((Block)block, (String)name);
        }

        public static Block registerBlock(Block block, Class<? extends ItemBlock> itemclass, String name) {
            return GameRegistry.registerBlock((Block)block, itemclass, (String)name);
        }

        public static void registerItem(Item item, String name) {
            GameRegistry.registerItem((Item)item, (String)name);
        }

        public static void registerTileEntity(Class<? extends TileEntity> tileEntityClass, String id) {
            GameRegistry.registerTileEntity(tileEntityClass, (String)id);
        }

        public static void registerOre(String name, Block block) {
            OreDictionary.registerOre((String)name, (Block)block);
        }

        public static void registerOre(String name, Item item) {
            OreDictionary.registerOre((String)name, (Item)item);
        }

        public static void registerOre(String name, ItemStack itemStack) {
            OreDictionary.registerOre((String)name, (ItemStack)itemStack);
        }
    }
}

