/*
 * Decompiled with CFR 0.152.
 */
package physica.api.core.abstraction;

import net.minecraftforge.common.util.ForgeDirection;

public enum Face {
    DOWN(0, -1, 0),
    UP(0, 1, 0),
    NORTH(0, 0, -1),
    SOUTH(0, 0, 1),
    WEST(-1, 0, 0),
    EAST(1, 0, 0),
    UNKNOWN(0, 0, 0);

    public static final Face[] VALID;
    public static final Face[] OPPOSITES;
    public static final int[][] ROTATION_MATRIX;
    public static final int[][] RELATIVE_MATRIX;
    public final int offsetX;
    public final int offsetY;
    public final int offsetZ;
    public final int flag;

    private Face(int x, int y, int z) {
        this.offsetX = x;
        this.offsetY = y;
        this.offsetZ = z;
        this.flag = 1 << this.ordinal();
    }

    public static Face getOrientation(int id) {
        if (id >= 0 && id < VALID.length) {
            return VALID[id];
        }
        return UNKNOWN;
    }

    public static Face Parse(Enum<?> obj) {
        return Face.getOrientation(obj.ordinal());
    }

    public static Face Parse(int ordinal) {
        return Face.getOrientation(ordinal);
    }

    public Face getOpposite() {
        return OPPOSITES[this.ordinal()];
    }

    public Face getRotation(Face axis) {
        return Face.getOrientation(ROTATION_MATRIX[axis.ordinal()][this.ordinal()]);
    }

    public Face getRelativeSide(Face relative) {
        if (relative == UNKNOWN || this == UNKNOWN) {
            return UNKNOWN;
        }
        return Face.getOrientation(RELATIVE_MATRIX[this.ordinal()][relative.ordinal()]);
    }

    public ForgeDirection Forge() {
        return ForgeDirection.getOrientation((int)this.ordinal());
    }

    static {
        VALID = new Face[]{DOWN, UP, NORTH, SOUTH, WEST, EAST};
        OPPOSITES = new Face[]{UP, DOWN, SOUTH, NORTH, EAST, WEST, UNKNOWN};
        ROTATION_MATRIX = new int[][]{{0, 1, 4, 5, 3, 2, 6}, {0, 1, 5, 4, 2, 3, 6}, {5, 4, 2, 3, 0, 1, 6}, {4, 5, 2, 3, 1, 0, 6}, {2, 3, 1, 0, 4, 5, 6}, {3, 2, 0, 1, 4, 5, 6}, {0, 1, 2, 3, 4, 5, 6}};
        RELATIVE_MATRIX = new int[][]{{3, 2, 1, 0, 5, 4}, {4, 5, 0, 1, 2, 3}, {0, 1, 3, 2, 4, 5}, {0, 1, 2, 3, 5, 4}, {0, 1, 5, 4, 3, 2}, {0, 1, 4, 5, 2, 3}};
    }
}

