/*
 * Decompiled with CFR 0.152.
 */
package physica.api.core.electricity;

import cofh.api.energy.IEnergyContainerItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public interface IElectricItem
extends IEnergyContainerItem {
    public static final String ENERGY_NBT_DATA = "Energy";

    default public int extractElectricity(ItemStack container, int maxExtract, boolean simulate) {
        if (container.field_77990_d == null || !container.field_77990_d.func_74764_b(ENERGY_NBT_DATA)) {
            return 0;
        }
        int energy = container.field_77990_d.func_74762_e(ENERGY_NBT_DATA);
        int energyExtracted = Math.min(energy, Math.min(this.getExtractRate(container), maxExtract));
        if (!simulate) {
            this.setEnergyStored(container, energy -= energyExtracted);
        }
        return energyExtracted;
    }

    default public int receiveElectricity(ItemStack container, int maxReceive, boolean simulate) {
        return 0;
    }

    default public int getElectricityStored(ItemStack container) {
        if (container.field_77990_d == null || !container.field_77990_d.func_74764_b(ENERGY_NBT_DATA)) {
            return 0;
        }
        return container.field_77990_d.func_74762_e(ENERGY_NBT_DATA);
    }

    default public int getElectricCapacity(ItemStack container) {
        return 0;
    }

    default public void setEnergyStored(ItemStack container, int amount) {
        if (container.field_77990_d == null) {
            container.field_77990_d = new NBTTagCompound();
        }
        int energyStored = (int)Math.max((double)Math.min(amount, this.getElectricCapacity(container)), 0.0);
        container.field_77990_d.func_74768_a(ENERGY_NBT_DATA, energyStored);
        container.func_77964_b((int)Math.max(0.0f, Math.abs((float)energyStored / (float)this.getElectricCapacity(container) * 100.0f - 100.0f)));
    }

    default public int getExtractRate(ItemStack container) {
        return this.getElectricCapacity(container);
    }

    default public int getReceiveRate(ItemStack container) {
        return this.getElectricCapacity(container);
    }

    @Override
    @Deprecated
    default public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        return this.extractElectricity(container, maxExtract, simulate);
    }

    @Override
    @Deprecated
    default public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        return this.receiveElectricity(container, maxReceive, simulate);
    }

    @Override
    @Deprecated
    default public int getEnergyStored(ItemStack container) {
        return this.getElectricityStored(container);
    }

    @Override
    @Deprecated
    default public int getMaxEnergyStored(ItemStack container) {
        return this.getElectricCapacity(container);
    }
}

