/*
 * Decompiled with CFR 0.152.
 */
package physica.api.core.tile;

import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import physica.api.core.abstraction.Face;
import physica.api.core.inventory.IGuiInterface;
import physica.api.core.inventory.IPlayerUsing;
import physica.api.core.misc.IRotatable;
import physica.api.core.network.ISidedObject;
import physica.library.location.GridLocation;
import physica.library.network.IPacket;
import physica.library.network.IPacketReciever;
import physica.library.network.netty.PacketSystem;
import physica.library.network.packet.PacketTile;

public interface ITileBase
extends IPlayerUsing,
ISidedObject,
IPacketReciever,
IRotatable {
    public static final int DESC_PACKET_ID = 0;
    public static final int GUI_PACKET_ID = 1;

    default public TileEntity This() {
        return (TileEntity)this;
    }

    default public boolean isClient() {
        return this.This().func_145831_w() != null && this.This().func_145831_w().field_72995_K;
    }

    default public boolean isServer() {
        return this.This().func_145831_w() != null && !this.This().func_145831_w().field_72995_K;
    }

    default public void onFirstUpdate() {
    }

    default public int getGuiSyncRate() {
        return 3;
    }

    default public int getSyncRate() {
        return 20;
    }

    default public GridLocation getLocation() {
        return new GridLocation(this.This());
    }

    default public boolean shouldSendGuiPacket(EntityPlayerMP playerMP) {
        return playerMP.func_70089_S() && playerMP.field_71070_bA != null;
    }

    default public boolean isPoweredByRedstone() {
        return this.This().func_145831_w().func_72864_z(this.This().field_145851_c, this.This().field_145848_d, this.This().field_145849_e);
    }

    default public int handleUpdate(int ticks) {
        if (ticks == 0) {
            this.onFirstUpdate();
        }
        this.handleUpdate(this.This().func_145831_w(), ticks);
        if (++ticks + 1 == Integer.MAX_VALUE) {
            ticks = 1;
        }
        if (this.isServer() && ticks % this.getGuiSyncRate() == 0 && this instanceof IGuiInterface) {
            Iterator<EntityPlayer> it = this.getPlayersUsingGui().iterator();
            while (it.hasNext()) {
                EntityPlayer player = it.next();
                if (player instanceof EntityPlayerMP && this.shouldSendGuiPacket((EntityPlayerMP)player)) {
                    PacketTile packet = new PacketTile("guiSync", 1, this.This());
                    ArrayList<Object> objects = new ArrayList<Object>();
                    this.writeClientGuiPacket(objects, player);
                    packet.addData(objects);
                    PacketSystem.INSTANCE.sendToPlayer(packet, (EntityPlayerMP)player);
                    continue;
                }
                it.remove();
            }
        }
        if (ticks % this.getSyncRate() == 0) {
            this.sendDescPacket();
        }
        return ticks;
    }

    default public void handleWriteToNBT(NBTTagCompound nbt) {
        if (this.isRotateAble()) {
            nbt.func_74768_a("facing", this.getFacing().ordinal());
        }
    }

    default public void handleReadFromNBT(NBTTagCompound nbt) {
        if (this.isRotateAble()) {
            this.setFacing(Face.getOrientation(nbt.func_74762_e("facing")));
        }
    }

    @Override
    default public boolean read(ByteBuf buf, int id, EntityPlayer player, IPacket type) {
        if (this.isClient()) {
            if (id == 0) {
                this.readSynchronizationPacket(buf, player);
                return true;
            }
            if (id == 1) {
                this.readClientGuiPacket(buf, player);
                return true;
            }
        }
        if (id != 0 && id != 1) {
            this.readCustomPacket(id, player, this.isClient() ? Side.CLIENT : Side.SERVER, type);
        }
        return false;
    }

    default public void readCustomPacket(int id, EntityPlayer player, Side side, IPacket type) {
    }

    default public void sendDescPacket() {
        if (this.isServer()) {
            PacketTile packetTile = new PacketTile("descSync", 0, this.This());
            ArrayList<Object> list = new ArrayList<Object>();
            this.writeSynchronizationPacket(list, null);
            packetTile.addData(list);
            if (list.isEmpty()) {
                return;
            }
            PacketSystem.INSTANCE.sendToAllAround((IPacket)packetTile, this.This());
        }
    }

    default public void readSynchronizationPacket(ByteBuf buf, EntityPlayer player) {
        if (this.isRotateAble()) {
            this.setFacing(Face.getOrientation(buf.readInt()));
        }
    }

    default public void readClientGuiPacket(ByteBuf buf, EntityPlayer player) {
    }

    default public void writeSynchronizationPacket(List<Object> dataList, EntityPlayer player) {
        if (this.isRotateAble()) {
            dataList.add(this.getFacing().ordinal());
        }
    }

    default public void writeClientGuiPacket(List<Object> dataList, EntityPlayer player) {
    }

    default public Set<TileEntity> getNearbyTiles(int radius) {
        HashSet<TileEntity> tiles = new HashSet<TileEntity>();
        for (int i = -radius; i <= radius; ++i) {
            for (int j = -radius; j <= radius; ++j) {
                for (int k = -radius; k <= radius; ++k) {
                    TileEntity tile = this.This().func_145831_w().func_147438_o(this.This().field_145851_c + i, this.This().field_145848_d + j, this.This().field_145849_e + k);
                    if (tile == this || tile == null) continue;
                    tiles.add(tile);
                }
            }
        }
        return tiles;
    }

    @Override
    default public Face getFacing() {
        return Face.UNKNOWN;
    }

    @Override
    default public void setFacing(Face facing) {
    }

    default public boolean isRotateAble() {
        return false;
    }

    public int getTicksRunning();
}

