/*
 * Decompiled with CFR 0.152.
 */
package physica.api.core.tile;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import physica.api.core.abstraction.Face;
import physica.api.core.tile.ITileBase;

public interface ITileBaseContainer
extends ITileBase,
ISidedInventory {
    public static final int[] ACCESSIBLE_SLOTS_NONE = new int[0];

    default public ItemStack func_70301_a(int slot) {
        return this.getInventoryArray()[slot];
    }

    default public ItemStack func_70298_a(int slot, int amount) {
        if (this.getInventoryArray()[slot] != null) {
            if (this.getInventoryArray()[slot].field_77994_a <= amount) {
                ItemStack itemstack = this.getInventoryArray()[slot];
                this.getInventoryArray()[slot] = null;
                this.func_70296_d();
                this.onInventoryChanged();
                return itemstack;
            }
            ItemStack itemstack = this.getInventoryArray()[slot].func_77979_a(amount);
            if (this.getInventoryArray()[slot].field_77994_a == 0) {
                this.getInventoryArray()[slot] = null;
            }
            this.func_70296_d();
            this.onInventoryChanged();
            return itemstack;
        }
        return null;
    }

    default public ItemStack func_70304_b(int slot) {
        if (this.getInventoryArray()[slot] != null) {
            ItemStack itemstack = this.getInventoryArray()[slot];
            this.getInventoryArray()[slot] = null;
            this.onInventoryChanged();
            return itemstack;
        }
        return null;
    }

    default public void func_70299_a(int slot, ItemStack stack) {
        this.getInventoryArray()[slot] = stack;
        this.onInventoryChanged();
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    default public void onInventoryChanged() {
        this.func_70296_d();
    }

    default public String func_145825_b() {
        return "container.physica.base";
    }

    default public boolean func_145818_k_() {
        return false;
    }

    @Override
    default public void handleReadFromNBT(NBTTagCompound nbt) {
        ITileBase.super.handleReadFromNBT(nbt);
        NBTTagList nbttaglist = nbt.func_150295_c("Items", 10);
        this.nullifyInventoryArray();
        for (int index = 0; index < nbttaglist.func_74745_c(); ++index) {
            NBTTagCompound save = nbttaglist.func_150305_b(index);
            int slotIndex = save.func_74771_c("Slot") & 0xFF;
            if (slotIndex < 0 || slotIndex >= this.getInventoryArray().length) continue;
            this.getInventoryArray()[slotIndex] = ItemStack.func_77949_a((NBTTagCompound)save);
        }
    }

    @Override
    default public void handleWriteToNBT(NBTTagCompound nbt) {
        ITileBase.super.handleWriteToNBT(nbt);
        NBTTagList nbttaglist = new NBTTagList();
        for (int slotIndex = 0; slotIndex < this.getInventoryArray().length; ++slotIndex) {
            if (this.getInventoryArray()[slotIndex] == null) continue;
            NBTTagCompound save = new NBTTagCompound();
            save.func_74774_a("Slot", (byte)slotIndex);
            this.getInventoryArray()[slotIndex].func_77955_b(save);
            nbttaglist.func_74742_a((NBTBase)save);
        }
        nbt.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    @Override
    default public void readSynchronizationPacket(ByteBuf buf, EntityPlayer player) {
        ITileBase.super.readSynchronizationPacket(buf, player);
        this.readClientGuiPacket(buf, player);
        this.handleReadFromNBT(ByteBufUtils.readTag((ByteBuf)buf));
    }

    @Override
    default public void writeSynchronizationPacket(List<Object> dataList, EntityPlayer player) {
        ITileBase.super.writeSynchronizationPacket(dataList, player);
        this.writeClientGuiPacket(dataList, player);
        NBTTagCompound tag = new NBTTagCompound();
        this.handleWriteToNBT(tag);
        dataList.add(tag);
    }

    default public int func_70297_j_() {
        return 64;
    }

    default public boolean func_70300_a(EntityPlayer player) {
        return this.This().func_145831_w().func_147438_o(this.This().field_145851_c, this.This().field_145848_d, this.This().field_145849_e) == this && player.func_70092_e((double)this.This().field_145851_c + 0.5, (double)this.This().field_145848_d + 0.5, (double)this.This().field_145849_e + 0.5) <= 64.0;
    }

    default public void func_70295_k_() {
    }

    default public void func_70305_f() {
    }

    default public boolean func_94041_b(int slot, ItemStack stack) {
        return false;
    }

    public ItemStack[] getInventoryArray();

    public void nullifyInventoryArray();

    default public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return this.canExtractItem(slot, stack, Face.Parse(side));
    }

    default public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.canInsertItem(slot, stack, Face.Parse(side));
    }

    default public int[] func_94128_d(int side) {
        return this.getAccessibleSlotsFromFace(Face.Parse(side));
    }

    default public boolean canExtractItem(int slot, ItemStack stack, Face face) {
        return false;
    }

    default public boolean canInsertItem(int slot, ItemStack stack, Face face) {
        return false;
    }

    default public int[] getAccessibleSlotsFromFace(Face face) {
        return ACCESSIBLE_SLOTS_NONE;
    }
}

