/*
 * Decompiled with CFR 0.152.
 */
package physica.api.core.tile;

import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import physica.api.core.abstraction.Face;
import physica.api.core.electricity.IElectricityReceiver;
import physica.api.core.tile.ITileBase;

public interface ITileBasePowered
extends ITileBase,
IElectricityReceiver {
    default public boolean hasEnoughEnergy() {
        return this.getElectricityStored() >= this.getPowerUsage();
    }

    default public int extractEnergy() {
        this.setElectricityStored(Math.max(0, this.getElectricityStored() - this.getPowerUsage()));
        return this.getPowerUsage();
    }

    @Override
    default public void handleWriteToNBT(NBTTagCompound nbt) {
        ITileBase.super.handleWriteToNBT(nbt);
        nbt.func_74768_a("Energy", this.getElectricityStored());
    }

    @Override
    default public void handleReadFromNBT(NBTTagCompound nbt) {
        ITileBase.super.handleReadFromNBT(nbt);
        this.setElectricityStored(nbt.func_74762_e("Energy"));
    }

    @Override
    default public void writeSynchronizationPacket(List<Object> dataList, EntityPlayer player) {
        ITileBase.super.writeSynchronizationPacket(dataList, player);
        dataList.add(this.getElectricityStored());
    }

    @Override
    default public void readSynchronizationPacket(ByteBuf buf, EntityPlayer player) {
        ITileBase.super.readSynchronizationPacket(buf, player);
        this.setElectricityStored(buf.readInt());
    }

    @Override
    default public int getElectricityStored(Face from) {
        return this.getElectricityStored();
    }

    @Override
    default public int receiveElectricity(Face from, int maxReceive, boolean simulate) {
        int capacityLeft = this.getElectricCapacity(from) - this.getElectricityStored();
        this.setElectricityStored(simulate ? this.getElectricityStored() : (capacityLeft >= maxReceive ? this.getElectricityStored() + maxReceive : this.getElectricCapacity(from)));
        return capacityLeft >= maxReceive ? maxReceive : capacityLeft;
    }

    @Override
    default public int getElectricCapacity(Face from) {
        return this.getPowerUsage() * 20;
    }

    default public int getPowerUsage() {
        return 0;
    }

    public int getElectricityStored();
}

