/*
 * Decompiled with CFR 0.152.
 */
package physica.api.core.tile;

import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import physica.api.core.abstraction.AbstractionLayer;
import physica.api.core.abstraction.Face;
import physica.api.core.electricity.IElectricityProvider;
import physica.api.core.tile.ITileBaseContainer;
import physica.api.core.tile.ITileBasePowered;

public interface ITileBasePoweredContainer
extends ITileBasePowered,
ITileBaseContainer {
    default public void drainBattery(int slot) {
        int power;
        ItemStack itemStack;
        if (this.receiveElectricity(Face.UNKNOWN, 1, true) > 0 && AbstractionLayer.Electricity.isItemElectric(itemStack = this.func_70301_a(slot)) && (power = AbstractionLayer.Electricity.getElectricityStored(itemStack)) > 0) {
            power = AbstractionLayer.Electricity.extractElectricity(itemStack, power, true);
            AbstractionLayer.Electricity.extractElectricity(itemStack, this.receiveElectricity(Face.UNKNOWN, power, false), false);
            this.func_70299_a(slot, itemStack);
        }
    }

    default public void fillBattery(int slot) {
        ItemStack itemStack;
        if (this instanceof IElectricityProvider && this.getElectricityStored(Face.UNKNOWN) > 0 && AbstractionLayer.Electricity.isItemElectric(itemStack = this.func_70301_a(slot))) {
            int powerEjectable = this.getElectricityStored(Face.UNKNOWN);
            powerEjectable = AbstractionLayer.Electricity.receiveElectricity(itemStack, powerEjectable, true);
            AbstractionLayer.Electricity.receiveElectricity(itemStack, ((IElectricityProvider)((Object)this)).extractElectricity(Face.UNKNOWN, powerEjectable, false), false);
        }
    }

    @Override
    default public void handleWriteToNBT(NBTTagCompound nbt) {
        ITileBaseContainer.super.handleWriteToNBT(nbt);
        ITileBasePowered.super.handleWriteToNBT(nbt);
    }

    @Override
    default public void handleReadFromNBT(NBTTagCompound nbt) {
        ITileBaseContainer.super.handleReadFromNBT(nbt);
        ITileBasePowered.super.handleReadFromNBT(nbt);
    }

    @Override
    default public void writeSynchronizationPacket(List<Object> dataList, EntityPlayer player) {
        ITileBasePowered.super.writeSynchronizationPacket(dataList, player);
        ITileBaseContainer.super.writeSynchronizationPacket(dataList, player);
        this.writeClientGuiPacket(dataList, player);
    }

    @Override
    default public void readSynchronizationPacket(ByteBuf buf, EntityPlayer player) {
        ITileBasePowered.super.readSynchronizationPacket(buf, player);
        ITileBaseContainer.super.readSynchronizationPacket(buf, player);
        this.readClientGuiPacket(buf, player);
    }

    @Override
    default public void writeClientGuiPacket(List<Object> dataList, EntityPlayer player) {
        ITileBaseContainer.super.writeClientGuiPacket(dataList, player);
        dataList.add(this.getElectricityStored());
    }

    @Override
    default public void readClientGuiPacket(ByteBuf buf, EntityPlayer player) {
        ITileBaseContainer.super.readClientGuiPacket(buf, player);
        this.setElectricityStored(buf.readInt());
    }
}

