/*
 * Decompiled with CFR 0.152.
 */
package physica.api.core.utilities;

import java.util.Random;
import physica.api.core.PhysicaAPI;
import physica.api.core.utilities.IRecipeUtilities;

public interface IBaseUtilities
extends IRecipeUtilities {
    public static Random randStatic() {
        return PhysicaAPI.random;
    }

    public static float switchRandomStatic(float val) {
        return IBaseUtilities.randStatic().nextBoolean() ? val : val * -1.0f;
    }

    public static double roundPreciseStatic(double value, int precision) {
        int scale = (int)Math.pow(10.0, precision);
        return (double)Math.round(value * (double)scale) / (double)scale;
    }

    public static float roundPreciseStatic(float value, int precision) {
        int scale = (int)Math.pow(10.0, precision);
        return Math.round((double)value * (double)scale) / (long)scale;
    }

    default public Random rand() {
        return IBaseUtilities.randStatic();
    }

    default public float switchRandom(float val) {
        return IBaseUtilities.randStatic().nextBoolean() ? val : val * -1.0f;
    }

    default public double roundPrecise(double value, int precision) {
        return IBaseUtilities.roundPreciseStatic(value, precision);
    }

    default public float roundPrecise(float value, int precision) {
        return (float)IBaseUtilities.roundPreciseStatic((double)value, precision);
    }
}

