/*
 * Decompiled with CFR 0.152.
 */
package physica.api.forcefield;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import physica.api.core.tile.ITileBase;
import physica.forcefield.common.ForcefieldFluidRegister;

public interface IInvFortronTile
extends ITileBase {
    public boolean isActivated();

    public Set<ITileBase> getFortronConnections();

    public FluidTank getFortronTank();

    default public boolean canSendBeam() {
        return this.isActivated() && this.getFortronTank().getFluidAmount() > 0 && this.getFortronConnections().size() > 0;
    }

    default public boolean canRecieveFortron(IInvFortronTile tile) {
        return this.getFortronTank().getCapacity() - this.getFortronTank().getFluidAmount() > 0;
    }

    default public int recieveFortron(int maxFill) {
        return this.getFortronTank().fill(new FluidStack(ForcefieldFluidRegister.LIQUID_FORTRON, maxFill), true);
    }

    default public int sendFortronTo(int maxSend, Class<?> ... types) {
        int ret = 0;
        HashSet<IInvFortronTile> send = new HashSet<IInvFortronTile>();
        for (ITileBase base : this.getFortronConnections()) {
            IInvFortronTile fortron = (IInvFortronTile)base;
            if (!fortron.canRecieveFortron(this) || !Arrays.asList(types).contains(base.getClass())) continue;
            send.add(fortron);
        }
        int size = send.size();
        for (IInvFortronTile tile : send) {
            int sent = tile.recieveFortron(maxSend / size);
            ret += sent;
            maxSend -= sent;
            --size;
        }
        return ret;
    }

    default public void invalidateConnections() {
        for (ITileBase base : this.getFortronConnections()) {
            if (!(base instanceof IInvFortronTile)) continue;
            ((IInvFortronTile)base).getFortronConnections().remove(this);
        }
        this.getFortronConnections().clear();
    }

    default public void validateConnections() {
        HashSet<ITileBase> invalid = new HashSet<ITileBase>();
        for (ITileBase base : this.getFortronConnections()) {
            if (!(base instanceof IInvFortronTile) || ((IInvFortronTile)base).getFrequency() == this.getFrequency()) continue;
            ((IInvFortronTile)base).getFortronConnections().remove(this);
            invalid.add(base);
        }
        this.getFortronConnections().removeAll(invalid);
    }

    default public int getFrequency() {
        return 0;
    }

    default public void setFrequency(int freq) {
    }

    default public void findNearbyConnections(Class<?> ... classes) {
        for (TileEntity tile : this.getNearbyTiles(5)) {
            IInvFortronTile fortronTile;
            if (!(tile instanceof IInvFortronTile) || tile.func_145837_r() || !Arrays.asList(classes).contains(tile.getClass()) || (fortronTile = (IInvFortronTile)tile).getFrequency() != this.getFrequency()) continue;
            this.getFortronConnections().add((ITileBase)tile);
            fortronTile.getFortronConnections().add(this);
        }
    }

    default public int getModuleCount(ItemStack compare, int fromSlot, int toSlot) {
        int ret = 0;
        if (compare != null) {
            IInventory inv = (IInventory)this;
            for (int i = fromSlot; i <= toSlot; ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (stack == null || compare.func_77973_b() != stack.func_77973_b() || stack.func_77960_j() != compare.func_77960_j()) continue;
                ret += stack.field_77994_a;
            }
        }
        return ret;
    }

    default public boolean findModule(ItemStack compare, int fromSlot, int toSlot) {
        if (compare != null) {
            IInventory inv = (IInventory)this;
            for (int i = fromSlot; i <= toSlot; ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (stack == null || compare.func_77973_b() != stack.func_77973_b() || stack.func_77960_j() != compare.func_77960_j()) continue;
                return true;
            }
        }
        return false;
    }

    default public int getModuleCountIn(ItemStack compare, int ... slots) {
        int ret = 0;
        if (compare != null && slots.length > 0) {
            IInventory inv = (IInventory)this;
            for (int slot : slots) {
                ItemStack stack;
                if (slot >= inv.func_70302_i_() || (stack = inv.func_70301_a(slot)) == null || compare.func_77973_b() != stack.func_77973_b() || stack.func_77960_j() != compare.func_77960_j()) continue;
                ret += stack.field_77994_a;
            }
        }
        return ret;
    }
}

