/*
 * Decompiled with CFR 0.152.
 */
package physica.core.client.nei;

import codechicken.nei.ItemList;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import physica.core.client.gui.GuiBlastFurnace;
import physica.core.client.nei.PhysicaRecipeHandlerBase;
import physica.core.common.CoreItemRegister;

public class BlastFurnaceRecipeHelper
extends PhysicaRecipeHandlerBase {
    public static ArrayList<FuelPair> afuels;
    public static HashSet<Block> efuels;

    private static Set<Item> excludedFuels() {
        HashSet<Item> efuels = new HashSet<Item>();
        efuels.add(Item.func_150898_a((Block)Blocks.field_150338_P));
        efuels.add(Item.func_150898_a((Block)Blocks.field_150337_Q));
        efuels.add(Item.func_150898_a((Block)Blocks.field_150472_an));
        efuels.add(Item.func_150898_a((Block)Blocks.field_150444_as));
        efuels.add(Item.func_150898_a((Block)Blocks.field_150466_ao));
        efuels.add(Item.func_150898_a((Block)Blocks.field_150447_bR));
        return efuels;
    }

    private static void findFuels() {
        afuels = new ArrayList();
        Set<Item> efuels = BlastFurnaceRecipeHelper.excludedFuels();
        for (ItemStack item : ItemList.items) {
            int burnTime;
            if (efuels.contains(item.func_77973_b()) || (burnTime = TileEntityFurnace.func_145952_a((ItemStack)item)) <= 0) continue;
            afuels.add(new FuelPair(item.func_77946_l(), burnTime));
        }
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(50, 23, 18, 18), "fuel", new Object[0]));
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(74, 23, 24, 18), this.getRecipeID(), new Object[0]));
    }

    public String getRecipeID() {
        return "Physica.BlastFurnace";
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiBlastFurnace.class;
    }

    @Override
    public String getRecipeName() {
        return "Blast Furnace";
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeID()) || outputId.equals("item") && results[0] != null && results[0] instanceof ItemStack && ((ItemStack)results[0]).func_77977_a().equals("item." + CoreItemRegister.itemMetaIngot.subItems.get(2))) {
            BlastFurnaceRecipeHelper.findFuels();
            this.arecipes.add(new SmeltingPair(new ItemStack(Items.field_151042_j, 2), new ItemStack((Item)CoreItemRegister.itemMetaIngot, 1, 2)));
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals(this.getRecipeID()) || inputId.equals("fuel") || inputId.equals("item") && ingredients[0] != null && ingredients[0] instanceof ItemStack && ((ItemStack)ingredients[0]).func_77977_a().equals("item." + CoreItemRegister.itemMetaIngot.subItems.get(2))) {
            BlastFurnaceRecipeHelper.findFuels();
            this.arecipes.add(new SmeltingPair(new ItemStack(Items.field_151042_j, 2), new ItemStack((Item)CoreItemRegister.itemMetaIngot, 1, 2)));
        }
    }

    @Override
    public String getGuiTexture() {
        return "textures/gui/container/furnace.png";
    }

    public void drawExtras(int recipe2) {
        this.drawProgressBar(51, 25, 176, 0, 14, 14, 48, 7);
        this.drawProgressBar(74, 23, 176, 14, 24, 16, 48, 0);
    }

    public String getOverlayIdentifier() {
        return "smelting";
    }

    public class SmeltingPair
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack ingred;
        PositionedStack result;

        public SmeltingPair(ItemStack ingred, ItemStack result) {
            super((TemplateRecipeHandler)BlastFurnaceRecipeHelper.this);
            ingred.field_77994_a = 2;
            this.ingred = new PositionedStack((Object)ingred, 51, 6);
            this.result = new PositionedStack((Object)result, 111, 24);
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(BlastFurnaceRecipeHelper.this.cycleticks / 48, Arrays.asList(this.ingred));
        }

        public PositionedStack getResult() {
            return this.result;
        }

        public PositionedStack getOtherStack() {
            return BlastFurnaceRecipeHelper.afuels.get((int)(BlastFurnaceRecipeHelper.this.cycleticks / 48 % BlastFurnaceRecipeHelper.afuels.size())).stack;
        }
    }

    public static class FuelPair {
        public PositionedStack stack;
        public int burnTime;

        public FuelPair(ItemStack ingred, int burnTime) {
            this.stack = new PositionedStack((Object)ingred, 51, 42, false);
            this.burnTime = burnTime;
        }
    }
}

