/*
 * Decompiled with CFR 0.152.
 */
package physica.core.client.render.tile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import physica.api.core.abstraction.AbstractionLayer;
import physica.api.core.abstraction.Face;
import physica.api.core.conductor.EnumConductorType;
import physica.core.common.tile.TileEnergyCable;
import physica.library.client.render.TessellatorWrapper;

@SideOnly(value=Side.CLIENT)
public class TileRenderEnergyCable
extends TileEntitySpecialRenderer {
    public static final ResourceLocation[] model_texture = new ResourceLocation[EnumConductorType.values().length];
    public static final float pixel = 0.0625f;
    public static final float pixelElevenTwo = 0.34375f;
    public static final float texPixel = 0.03125f;

    public static void drawConnection(Face direction) {
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        if (direction == Face.DOWN) {
            GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        } else if (direction == Face.NORTH) {
            GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        } else if (direction == Face.SOUTH) {
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        } else if (direction == Face.EAST) {
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        } else if (direction == Face.WEST) {
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        TessellatorWrapper tess = TessellatorWrapper.instance;
        tess.startDrawingQuads();
        float fiveTex = 0.15625f;
        tess.addVertexWithUV(0.65625, 0.65625, 0.65625, fiveTex, fiveTex);
        tess.addVertexWithUV(0.65625, 1.0, 0.65625, fiveTex * 2.0f, fiveTex);
        tess.addVertexWithUV(0.34375, 1.0, 0.65625, fiveTex * 2.0f, 0.0);
        tess.addVertexWithUV(0.34375, 0.65625, 0.65625, fiveTex, 0.0);
        tess.addVertexWithUV(0.34375, 0.65625, 0.34375, fiveTex, 0.0);
        tess.addVertexWithUV(0.34375, 1.0, 0.34375, fiveTex * 2.0f, 0.0);
        tess.addVertexWithUV(0.65625, 1.0, 0.34375, fiveTex * 2.0f, fiveTex);
        tess.addVertexWithUV(0.65625, 0.65625, 0.34375, fiveTex, fiveTex);
        tess.addVertexWithUV(0.65625, 0.65625, 0.34375, fiveTex, 0.0);
        tess.addVertexWithUV(0.65625, 1.0, 0.34375, fiveTex * 2.0f, 0.0);
        tess.addVertexWithUV(0.65625, 1.0, 0.65625, fiveTex * 2.0f, fiveTex);
        tess.addVertexWithUV(0.65625, 0.65625, 0.65625, fiveTex, fiveTex);
        tess.addVertexWithUV(0.34375, 0.65625, 0.65625, fiveTex, fiveTex);
        tess.addVertexWithUV(0.34375, 1.0, 0.65625, fiveTex * 2.0f, fiveTex);
        tess.addVertexWithUV(0.34375, 1.0, 0.34375, fiveTex * 2.0f, 0.0);
        tess.addVertexWithUV(0.34375, 0.65625, 0.34375, fiveTex, 0.0);
        tess.draw();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        if (direction == Face.DOWN) {
            GL11.glRotatef((float)-180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        } else if (direction == Face.NORTH) {
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        } else if (direction == Face.SOUTH) {
            GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        } else if (direction == Face.EAST) {
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        } else if (direction == Face.WEST) {
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
    }

    public static void drawCore() {
        TessellatorWrapper tess = TessellatorWrapper.instance;
        tess.startDrawingQuads();
        float fiveTex = 0.15625f;
        tess.addVertexWithUV(0.65625, 0.34375, 0.65625, fiveTex, fiveTex);
        tess.addVertexWithUV(0.65625, 0.65625, 0.65625, fiveTex, 0.0);
        tess.addVertexWithUV(0.34375, 0.65625, 0.65625, 0.0, 0.0);
        tess.addVertexWithUV(0.34375, 0.34375, 0.65625, 0.0, fiveTex);
        tess.addVertexWithUV(0.65625, 0.34375, 0.34375, fiveTex, fiveTex);
        tess.addVertexWithUV(0.65625, 0.65625, 0.34375, fiveTex, 0.0);
        tess.addVertexWithUV(0.65625, 0.65625, 0.65625, 0.0, 0.0);
        tess.addVertexWithUV(0.65625, 0.34375, 0.65625, 0.0, fiveTex);
        tess.addVertexWithUV(0.34375, 0.34375, 0.34375, 0.0, fiveTex);
        tess.addVertexWithUV(0.34375, 0.65625, 0.34375, 0.0, 0.0);
        tess.addVertexWithUV(0.65625, 0.65625, 0.34375, fiveTex, 0.0);
        tess.addVertexWithUV(0.65625, 0.34375, 0.34375, fiveTex, fiveTex);
        tess.addVertexWithUV(0.34375, 0.34375, 0.65625, 0.0, fiveTex);
        tess.addVertexWithUV(0.34375, 0.65625, 0.65625, 0.0, 0.0);
        tess.addVertexWithUV(0.34375, 0.65625, 0.34375, fiveTex, 0.0);
        tess.addVertexWithUV(0.34375, 0.34375, 0.34375, fiveTex, fiveTex);
        tess.addVertexWithUV(0.65625, 0.65625, 0.65625, 0.0, fiveTex);
        tess.addVertexWithUV(0.65625, 0.65625, 0.34375, 0.0, 0.0);
        tess.addVertexWithUV(0.34375, 0.65625, 0.34375, fiveTex, 0.0);
        tess.addVertexWithUV(0.34375, 0.65625, 0.65625, fiveTex, fiveTex);
        tess.addVertexWithUV(0.34375, 0.34375, 0.65625, fiveTex, fiveTex);
        tess.addVertexWithUV(0.34375, 0.34375, 0.34375, fiveTex, 0.0);
        tess.addVertexWithUV(0.65625, 0.34375, 0.34375, 0.0, 0.0);
        tess.addVertexWithUV(0.65625, 0.34375, 0.65625, 0.0, fiveTex);
        tess.draw();
    }

    public final void func_147500_a(TileEntity tile, double x, double y, double z, float deltaFrame) {
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        GL11.glPushAttrib((int)8192);
        RenderHelper.func_74518_a();
        GL11.glTranslated((double)x, (double)y, (double)z);
        int meta = tile.func_145832_p();
        this.func_147499_a(model_texture[Math.max(0, Math.min(model_texture.length - 1, meta))]);
        boolean isCross = false;
        boolean finished = false;
        int connections = 0;
        int differentLocations = 0;
        Face last = Face.UNKNOWN;
        for (Face dir : Face.VALID) {
            TileEntity sideTile = tile.func_145831_w().func_147438_o(tile.field_145851_c + dir.offsetX, tile.field_145848_d + dir.offsetY, tile.field_145849_e + dir.offsetZ);
            if (!AbstractionLayer.Electricity.canConnectElectricity(sideTile, dir.getOpposite())) continue;
            TileRenderEnergyCable.drawConnection(dir);
            if (sideTile.func_145832_p() == meta && sideTile instanceof TileEnergyCable) {
                ++connections;
            } else {
                ++differentLocations;
            }
            if (finished) continue;
            if (isCross) {
                if (dir == last.getOpposite()) continue;
                isCross = false;
                finished = true;
                continue;
            }
            last = dir;
            isCross = true;
        }
        if (isCross && connections != 1 && differentLocations <= 0) {
            GL11.glTranslated((double)((float)last.offsetX * 0.34375f), (double)((float)last.offsetY * 0.34375f), (double)((float)last.offsetZ * 0.34375f));
            TileRenderEnergyCable.drawConnection(last.getOpposite());
        } else {
            TileRenderEnergyCable.drawCore();
        }
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    static {
        for (EnumConductorType type : EnumConductorType.values()) {
            TileRenderEnergyCable.model_texture[type.ordinal()] = new ResourceLocation("physica", "textures/models/" + type.getName() + "cable.png");
        }
    }
}

