/*
 * Decompiled with CFR 0.152.
 */
package physica.core.common;

import net.minecraft.block.Block;
import net.minecraft.util.EnumChatFormatting;
import physica.api.core.abstraction.AbstractionLayer;
import physica.api.core.conductor.EnumConductorType;
import physica.api.core.load.IContent;
import physica.api.core.load.LoadPhase;
import physica.core.common.block.BlockBatteryBox;
import physica.core.common.block.BlockBlastFurnace;
import physica.core.common.block.BlockCircuitPress;
import physica.core.common.block.BlockCoalGenerator;
import physica.core.common.block.BlockElectricFurnace;
import physica.core.common.block.BlockEnergyCable;
import physica.core.common.block.BlockFulmination;
import physica.core.common.block.BlockInfiniteEnergy;
import physica.core.common.block.BlockLead;
import physica.core.common.block.BlockOre;
import physica.core.common.configuration.ConfigCore;
import physica.core.common.tile.TileBatteryBox;
import physica.core.common.tile.TileBlastFurnace;
import physica.core.common.tile.TileCircuitPress;
import physica.core.common.tile.TileCoalGenerator;
import physica.core.common.tile.TileElectricFurnace;
import physica.core.common.tile.TileEnergyCable;
import physica.core.common.tile.TileFulmination;
import physica.core.common.tile.TileInfiniteEnergy;
import physica.library.energy.ElectricityDisplay;
import physica.library.energy.ElectricityUtilities;
import physica.library.energy.base.Unit;
import physica.library.item.ItemBlockDescriptable;
import physica.library.item.ItemBlockMetadata;

public class CoreBlockRegister
implements IContent {
    public static BlockInfiniteEnergy blockInfEnergy;
    public static BlockFulmination blockFulmination;
    public static BlockBlastFurnace blockBlastFurnace;
    public static BlockCoalGenerator blockCoalGenerator;
    public static BlockElectricFurnace blockElectricFurnace;
    public static BlockCircuitPress blockCircuitPress;
    public static BlockBatteryBox blockBatteryBox;
    public static BlockEnergyCable blockCable;
    public static BlockLead blockLead;
    public static BlockOre blockTinOre;
    public static BlockOre blockCopperOre;
    public static BlockOre blockLeadOre;
    public static BlockOre blockSilverOre;

    @Override
    public void register(LoadPhase phase) {
        if (phase == LoadPhase.RegisterObjects) {
            blockCoalGenerator = new BlockCoalGenerator();
            AbstractionLayer.Registering.registerBlock((Block)blockCoalGenerator, ItemBlockDescriptable.class, "coalGenerator");
            AbstractionLayer.Registering.registerTileEntity(TileCoalGenerator.class, "physica:coalGenerator");
            blockBatteryBox = new BlockBatteryBox();
            AbstractionLayer.Registering.registerBlock((Block)blockBatteryBox, ItemBlockMetadata.class, "batteryBox");
            AbstractionLayer.Registering.registerTileEntity(TileBatteryBox.class, "physica:batteryBox");
            blockElectricFurnace = new BlockElectricFurnace();
            AbstractionLayer.Registering.registerBlock((Block)blockElectricFurnace, ItemBlockMetadata.class, "electricFurnace");
            AbstractionLayer.Registering.registerTileEntity(TileElectricFurnace.class, "physica:electricFurnace");
            blockCircuitPress = new BlockCircuitPress();
            AbstractionLayer.Registering.registerBlock((Block)blockCircuitPress, ItemBlockDescriptable.class, "circuitPress");
            AbstractionLayer.Registering.registerTileEntity(TileCircuitPress.class, "physica:circuitPress");
            blockBlastFurnace = new BlockBlastFurnace();
            AbstractionLayer.Registering.registerBlock((Block)blockBlastFurnace, ItemBlockDescriptable.class, "blastFurnace");
            AbstractionLayer.Registering.registerTileEntity(TileBlastFurnace.class, "physica:blastFurnace");
            blockFulmination = new BlockFulmination();
            AbstractionLayer.Registering.registerBlock(blockFulmination, ItemBlockDescriptable.class, "fulmination");
            AbstractionLayer.Registering.registerTileEntity(TileFulmination.class, "physica:fulmination");
            blockInfEnergy = new BlockInfiniteEnergy();
            AbstractionLayer.Registering.registerBlock(blockInfEnergy, ItemBlockDescriptable.class, "infEnergy");
            AbstractionLayer.Registering.registerTileEntity(TileInfiniteEnergy.class, "physica:infEnergy");
            blockCable = new BlockEnergyCable();
            AbstractionLayer.Registering.registerBlock(blockCable, ItemBlockMetadata.class, "energyCable");
            AbstractionLayer.Registering.registerTileEntity(TileEnergyCable.class, "physica:energyCable");
            blockLead = new BlockLead();
            AbstractionLayer.Registering.registerBlock((Block)blockLead, "blockLead");
            blockTinOre = new BlockOre("tinOre", ConfigCore.TIN_ORE_HARVEST_LEVEL);
            AbstractionLayer.Registering.registerBlock(blockTinOre, "tinOre");
            blockCopperOre = new BlockOre("copperOre", ConfigCore.COPPER_ORE_HARVEST_LEVEL);
            AbstractionLayer.Registering.registerBlock(blockCopperOre, "copperOre");
            blockLeadOre = new BlockOre("leadOre", ConfigCore.LEAD_ORE_HARVEST_LEVEL);
            AbstractionLayer.Registering.registerBlock(blockLeadOre, "leadOre");
            blockSilverOre = new BlockOre("silverOre", ConfigCore.SILVER_ORE_HARVEST_LEVEL);
            AbstractionLayer.Registering.registerBlock(blockSilverOre, "silverOre");
            AbstractionLayer.Registering.registerOre("oreLead", blockLeadOre);
            AbstractionLayer.Registering.registerOre("oreTin", blockTinOre);
            AbstractionLayer.Registering.registerOre("oreCopper", blockCopperOre);
            AbstractionLayer.Registering.registerOre("oreSilver", blockSilverOre);
            for (EnumConductorType en : EnumConductorType.values()) {
                if (en == EnumConductorType.superconductor) {
                    ItemBlockDescriptable.addDescription(blockCable, en.ordinal(), EnumChatFormatting.GREEN + "\u041c\u0430\u043a\u0441. \u043c\u043e\u0449\u043d\u043e\u0441\u0442\u044c: " + EnumChatFormatting.GRAY + ElectricityDisplay.getDisplay(ElectricityUtilities.convertEnergy((double)en.getTransferRate(), Unit.RF, Unit.WATT), Unit.WATT), EnumChatFormatting.GREEN + "\u041c\u0430\u043a\u0441. \u043d\u0430\u043f\u0440\u044f\u0436\u0435\u043d\u0438\u0435:" + EnumChatFormatting.GRAY + " \u0431\u0435\u0441\u043a.");
                } else {
                    ItemBlockDescriptable.addDescription(blockCable, en.ordinal(), EnumChatFormatting.GREEN + "\u041c\u0430\u043a\u0441. \u043c\u043e\u0449\u043d\u043e\u0441\u0442\u044c: " + EnumChatFormatting.GRAY + ElectricityDisplay.getDisplay(ElectricityUtilities.convertEnergy((double)en.getTransferRate(), Unit.RF, Unit.WATT), Unit.WATT), EnumChatFormatting.GREEN + "\u041c\u0430\u043a\u0441. \u043d\u0430\u043f\u0440\u044f\u0436\u0435\u043d\u0438\u0435: " + EnumChatFormatting.GRAY + en.getVoltage() + " \u0412\u043e\u043b\u044c\u0442");
                }
                ItemBlockDescriptable.addDescriptionShifted(blockCable, en.ordinal(), "\u041f\u0435\u0440\u0435\u0434\u0430\u0435\u0442 \u044d\u043d\u0435\u0440\u0433\u0438\u044e \u043e\u0442 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430 \u043a \u0440\u0430\u0437\u043b\u0438\u0447\u043d\u044b\u043c \u043f\u043e\u043b\u0443\u0447\u0430\u0442\u0435\u043b\u044f\u043c \u044d\u043d\u0435\u0440\u0433\u0438\u0438 \u0441\u0435\u0442\u0438.");
            }
            ItemBlockDescriptable.addDescription((Block)blockBatteryBox, 0, EnumChatFormatting.GREEN + "\u0412\u043c\u0435\u0441\u0442\u0438\u043c\u043e\u0441\u0442\u044c: " + EnumChatFormatting.GRAY + ElectricityDisplay.getDisplayShort(ElectricityUtilities.convertEnergy((double)BlockBatteryBox.EnumBatteryBox.BASIC.getCapacity(), Unit.WATT, Unit.WATTHOUR), Unit.WATTHOUR), EnumChatFormatting.GREEN + "\u041e\u0431\u043c\u0435\u043d \u044d\u043d\u0435\u0440\u0433\u0438\u0438: " + EnumChatFormatting.GRAY + ElectricityDisplay.getDisplay(ElectricityUtilities.convertEnergy(BlockBatteryBox.EnumBatteryBox.BASIC.getCapacity() / 500, Unit.WATT, Unit.WATT), Unit.WATT));
            ItemBlockDescriptable.addDescription((Block)blockBatteryBox, 1, EnumChatFormatting.GREEN + "\u0412\u043c\u0435\u0441\u0442\u0438\u043c\u043e\u0441\u0442\u044c: " + EnumChatFormatting.GRAY + ElectricityDisplay.getDisplayShort(ElectricityUtilities.convertEnergy((double)BlockBatteryBox.EnumBatteryBox.ADVANCED.getCapacity(), Unit.WATT, Unit.WATTHOUR), Unit.WATTHOUR), EnumChatFormatting.GREEN + "\u041e\u0431\u043c\u0435\u043d \u044d\u043d\u0435\u0440\u0433\u0438\u0438: " + EnumChatFormatting.GRAY + ElectricityDisplay.getDisplay(ElectricityUtilities.convertEnergy(BlockBatteryBox.EnumBatteryBox.ADVANCED.getCapacity() / 500, Unit.WATT, Unit.WATT), Unit.WATT));
            ItemBlockDescriptable.addDescription((Block)blockBatteryBox, 2, EnumChatFormatting.GREEN + "\u0412\u043c\u0435\u0441\u0442\u0438\u043c\u043e\u0441\u0442\u044c: " + EnumChatFormatting.GRAY + ElectricityDisplay.getDisplayShort(ElectricityUtilities.convertEnergy((double)BlockBatteryBox.EnumBatteryBox.ELITE.getCapacity(), Unit.WATT, Unit.WATTHOUR), Unit.WATTHOUR), EnumChatFormatting.GREEN + "\u041e\u0431\u043c\u0435\u043d \u044d\u043d\u0435\u0440\u0433\u0438\u0438: " + EnumChatFormatting.GRAY + ElectricityDisplay.getDisplay(ElectricityUtilities.convertEnergy(BlockBatteryBox.EnumBatteryBox.ELITE.getCapacity() / 500, Unit.WATT, Unit.WATT), Unit.WATT));
            ItemBlockDescriptable.addDescription((Block)blockElectricFurnace, 0, EnumChatFormatting.GREEN + "\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u044d\u043d\u0435\u0440\u0433\u0438\u0438: " + EnumChatFormatting.GRAY + ElectricityDisplay.getDisplay(ElectricityUtilities.convertEnergy(TileElectricFurnace.POWER_USAGE, Unit.RF, Unit.WATT), Unit.WATT));
            ItemBlockDescriptable.addDescription((Block)blockElectricFurnace, 1, EnumChatFormatting.GREEN + "\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u044d\u043d\u0435\u0440\u0433\u0438\u0438: " + EnumChatFormatting.GRAY + ElectricityDisplay.getDisplay(ElectricityUtilities.convertEnergy(TileElectricFurnace.POWER_USAGE * 3, Unit.RF, Unit.WATT), Unit.WATT));
            ItemBlockDescriptable.addDescriptionShifted((Block)blockBatteryBox, 0, "\u0411\u043b\u043e\u043a, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u043c\u043e\u0436\u043d\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0434\u043b\u044f \u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u044d\u043d\u0435\u0440\u0433\u0438\u0438.");
            ItemBlockDescriptable.addDescriptionShifted((Block)blockBatteryBox, 1, "\u0411\u043b\u043e\u043a, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u043c\u043e\u0436\u043d\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0434\u043b\u044f \u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u044d\u043d\u0435\u0440\u0433\u0438\u0438");
            ItemBlockDescriptable.addDescriptionShifted((Block)blockBatteryBox, 2, "\u0411\u043b\u043e\u043a, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u043c\u043e\u0436\u043d\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0434\u043b\u044f \u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u044d\u043d\u0435\u0440\u0433\u0438\u0438");
            ItemBlockDescriptable.addDescriptionShifted(blockInfEnergy, 0, "\u0418\u0437\u043b\u0443\u0447\u0430\u0435\u0442 \u0431\u0435\u0441\u043a\u043e\u043d\u0435\u0447\u043d\u0443\u044e \u044d\u043d\u0435\u0440\u0433\u0438\u044e \u0432 \u0431\u043b\u0438\u0436\u0430\u0439\u0448\u0438\u0435 \u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a\u0438.");
            ItemBlockDescriptable.addDescriptionShifted(blockFulmination, 0, "\u0421\u043e\u0431\u0438\u0440\u0430\u0435\u0442 \u044d\u043d\u0435\u0440\u0433\u0438\u044e \u043e\u0442 \u0432\u0437\u0440\u044b\u0432\u043e\u0432.");
            ItemBlockDescriptable.addDescriptionShifted((Block)blockBlastFurnace, 0, "\u0412\u044b\u043f\u043b\u0430\u0432\u043b\u044f\u0435\u0442 \u0436\u0435\u043b\u0435\u0437\u043e \u0438 \u0441\u043e\u0435\u0434\u0438\u043d\u044f\u0435\u0442 \u0435\u0433\u043e \u0441 \u0443\u0433\u043b\u0435\u0440\u043e\u0434\u043e\u043c", " \u0434\u043b\u044f \u043f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0441\u0442\u0432\u0430 \u0441\u0442\u0430\u043b\u0438.");
            ItemBlockDescriptable.addDescriptionShifted((Block)blockCoalGenerator, 0, "\u0412\u044b\u0440\u0430\u0431\u0430\u0442\u044b\u0432\u0430\u0435\u0442 \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u044d\u043d\u0435\u0440\u0433\u0438\u044e, \u0441\u0436\u0438\u0433\u0430\u044f \u0443\u0433\u043e\u043b\u044c.");
            ItemBlockDescriptable.addDescriptionShifted((Block)blockElectricFurnace, 0, "\u042d\u0442\u043e\u0442 \u0431\u043b\u043e\u043a \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0431\u043e\u043b\u0435\u0435 \u0431\u044b\u0441\u0442\u0440\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0435\u0439 \u043f\u0435\u0447\u0438, \u0440\u0430\u0431\u043e\u0442\u0430\u044e\u0449\u0435\u0439 \u043d\u0430 \u044d\u043b\u0435\u043a\u0442\u0440\u0438\u0447\u0435\u0441\u0442\u0432\u0435.");
            ItemBlockDescriptable.addDescriptionShifted((Block)blockElectricFurnace, 1, "\u042d\u0442\u043e\u0442 \u0431\u043b\u043e\u043a \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u044f\u0435\u0442 \u0441\u043e\u0431\u043e\u0439 \u0431\u043e\u043b\u0435\u0435 \u0431\u044b\u0441\u0442\u0440\u0443\u044e \u0432\u0435\u0440\u0441\u0438\u044e \u043a\u0430\u043a \u043f\u0435\u0447\u0438, \u0442\u0430\u043a \u0438 \u044d\u043b\u0435\u043a\u0442\u0440\u0438\u0447\u0435\u0441\u043a\u043e\u0439 \u043f\u0435\u0447\u0438, \u043a\u043e\u0442\u043e\u0440\u0430\u044f \u0440\u0430\u0431\u043e\u0442\u0430\u0435\u0442 \u043d\u0430 \u044d\u043b\u0435\u043a\u0442\u0440\u0438\u0447\u0435\u0441\u0442\u0432\u0435, \u043a\u043e\u0442\u043e\u0440\u0430\u044f \u0442\u0430\u043a\u0436\u0435 \u0443\u0434\u0432\u0430\u0438\u0432\u0430\u0435\u0442 \u0434\u043e\u0431\u044b\u0447\u0443 \u0440\u0443\u0434\u044b \u043f\u0440\u0438 \u043f\u043b\u0430\u0432\u043a\u0435.");
            ItemBlockDescriptable.addDescriptionShifted((Block)blockCircuitPress, 0, "\u042d\u0442\u043e\u0442 \u0431\u043b\u043e\u043a \u043f\u0440\u0435\u0441\u0441\u0443\u0435\u0442 \u0440\u0430\u0437\u043d\u044b\u0435 \u0438\u043d\u0433\u0440\u0435\u0434\u0438\u0435\u043d\u0442\u044b \u0432 \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u0441\u0445\u0435\u043c\u044b");
        }
    }
}

