/*
 * Decompiled with CFR 0.152.
 */
package physica.core.common.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import physica.api.core.abstraction.Face;
import physica.api.core.abstraction.recipe.IRecipeRegister;
import physica.api.core.conductor.EnumConductorType;
import physica.api.core.utilities.IBaseUtilities;
import physica.core.common.CoreBlockRegister;
import physica.core.common.CoreTabRegister;
import physica.core.common.tile.TileBatteryBox;
import physica.library.block.BlockBaseContainer;

public class BlockBatteryBox
extends BlockBaseContainer
implements IBaseUtilities,
IRecipeRegister {
    @SideOnly(value=Side.CLIENT)
    private IIcon machineSide;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconFacing;
    @SideOnly(value=Side.CLIENT)
    private IIcon machineOutput;
    @SideOnly(value=Side.CLIENT)
    private IIcon machineInput;

    public BlockBatteryBox() {
        super(Material.field_151573_f);
        this.func_149711_c(1.0f);
        this.func_149752_b(5.0f);
        this.setHarvestLevel("pickaxe", 2);
        this.func_149647_a(CoreTabRegister.coreTab);
        this.func_149663_c("physica:batteryBox");
        this.func_149658_d("physica:machine/batterybox");
        this.addToRegister("Core", this);
    }

    public void func_149651_a(IIconRegister reg) {
        this.field_149761_L = reg.func_94245_a("physica:machine/machineside");
        this.machineOutput = reg.func_94245_a("physica:machine/machineoutput");
        this.machineInput = reg.func_94245_a("physica:machine/machineinput");
        this.iconFacing = reg.func_94245_a(this.func_149641_N());
    }

    public int func_149741_i(int meta) {
        return EnumBatteryBox.values()[meta].getRenderColor();
    }

    public int func_149720_d(IBlockAccess world, int x, int y, int z) {
        return this.func_149741_i(world.func_72805_g(x, y, z));
    }

    public IIcon func_149673_e(IBlockAccess access, int x, int y, int z, int side) {
        TileEntity tile = access.func_147438_o(x, y, z);
        if (tile instanceof TileBatteryBox) {
            TileBatteryBox generator = (TileBatteryBox)tile;
            Face facing = generator.getFacing();
            if (side == facing.getOpposite().getRelativeSide(Face.EAST).ordinal()) {
                return this.machineOutput;
            }
            if (side == facing.getOpposite().getRelativeSide(Face.WEST).ordinal()) {
                return this.machineInput;
            }
        }
        return side <= 1 ? this.field_149761_L : this.iconFacing;
    }

    public IIcon func_149691_a(int side, int meta) {
        return side <= 1 ? this.field_149761_L : (side == 4 ? this.machineInput : (side == 5 ? this.machineOutput : this.iconFacing));
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileBatteryBox();
    }

    @Override
    public void registerRecipes() {
        this.addRecipe(new ItemStack((Block)this, 1, 0), new Object[]{"SSS", "BBB", "SSS", Character.valueOf('S'), "ingotSteel", Character.valueOf('B'), "phyBattery"});
        this.addRecipe(new ItemStack((Block)this, 1, 1), new Object[]{"BTB", "WWW", "BAB", Character.valueOf('T'), new ItemStack((Block)this, 1, 0), Character.valueOf('A'), "circuitAdvanced", Character.valueOf('W'), new ItemStack((Block)CoreBlockRegister.blockCable, 1, 0), Character.valueOf('B'), "phyBattery"});
        this.addRecipe(new ItemStack((Block)this, 1, 2), new Object[]{"BEB", "TWT", "BEB", Character.valueOf('T'), new ItemStack((Block)this, 1, 1), Character.valueOf('E'), "circuitElite", Character.valueOf('W'), new ItemStack((Block)CoreBlockRegister.blockCable, 1, EnumConductorType.superconductor.ordinal()), Character.valueOf('B'), "phyBattery"});
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (EnumBatteryBox type : EnumBatteryBox.values()) {
            list.add(new ItemStack(item, 1, type.ordinal()));
        }
    }

    @Override
    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack itemStack) {
        super.func_149689_a(world, x, y, z, entity, itemStack);
        world.func_72921_c(x, y, z, itemStack.func_77960_j(), 3);
    }

    public int func_149692_a(int metadata) {
        return metadata;
    }

    public static enum EnumBatteryBox {
        BASIC(5000000, 0xFFFFFF),
        ADVANCED(20000000, -6575175),
        ELITE(80000000, -10129545);

        private final int capacity;
        private final int renderColor;

        private EnumBatteryBox(int capacity, int renderColor) {
            this.capacity = capacity;
            this.renderColor = renderColor;
        }

        public int getCapacity() {
            return this.capacity;
        }

        public int getRenderColor() {
            return this.renderColor;
        }
    }
}

