/*
 * Decompiled with CFR 0.152.
 */
package physica.core.common.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import physica.api.core.abstraction.Face;
import physica.api.core.abstraction.recipe.IRecipeRegister;
import physica.api.core.utilities.IBaseUtilities;
import physica.core.common.CoreTabRegister;
import physica.core.common.tile.TileCoalGenerator;
import physica.library.block.BlockBaseContainer;

public class BlockCoalGenerator
extends BlockBaseContainer
implements IBaseUtilities,
IRecipeRegister {
    @SideOnly(value=Side.CLIENT)
    private IIcon iconFacing;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconFacingRunning;
    @SideOnly(value=Side.CLIENT)
    private IIcon machineOutput;

    public BlockCoalGenerator() {
        super(Material.field_151573_f);
        this.func_149711_c(1.0f);
        this.func_149752_b(5.0f);
        this.setHarvestLevel("pickaxe", 2);
        this.func_149647_a(CoreTabRegister.coreTab);
        this.func_149663_c("physica:coalGenerator");
        this.func_149658_d("physica:machine/coalgenerator");
        this.addToRegister("Core", this);
    }

    public void func_149651_a(IIconRegister reg) {
        this.field_149761_L = reg.func_94245_a("physica:machine/machineside");
        this.machineOutput = reg.func_94245_a("physica:machine/machineoutput");
        this.iconFacing = reg.func_94245_a(this.func_149641_N() + "facing");
        this.iconFacingRunning = reg.func_94245_a(this.func_149641_N() + "facingrunning");
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileCoalGenerator tile = (TileCoalGenerator)world.func_147438_o(x, y, z);
        return tile.generate > 0.0 ? Blocks.field_150353_l.func_149750_m() : 0;
    }

    public IIcon func_149673_e(IBlockAccess access, int x, int y, int z, int side) {
        TileEntity tile = access.func_147438_o(x, y, z);
        if (tile instanceof TileCoalGenerator) {
            Face facing = ((TileCoalGenerator)tile).getFacing();
            if (side == facing.ordinal()) {
                return ((TileCoalGenerator)tile).generate > 0.0 ? this.iconFacingRunning : this.iconFacing;
            }
            if (side == facing.getOpposite().ordinal()) {
                return this.machineOutput;
            }
        }
        return this.field_149761_L;
    }

    public IIcon func_149691_a(int side, int meta) {
        if (side == 4) {
            return this.iconFacing;
        }
        return this.field_149761_L;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileCoalGenerator) {
            TileCoalGenerator generator = (TileCoalGenerator)tile;
            if (generator.generate > 0.0) {
                int ordinal = generator.getFacing().ordinal();
                float xLoc = (float)x + 0.5f;
                float yLoc = (float)y + 0.25f + rand.nextFloat() * 6.0f / 16.0f;
                float zLoc = (float)z + 0.5f;
                float offset1 = 0.52f;
                float offset2 = rand.nextFloat() * 0.6f - 0.3f;
                if (ordinal == 4) {
                    world.func_72869_a("smoke", (double)(xLoc - offset1), (double)yLoc, (double)(zLoc + offset2), 0.0, 0.0, 0.0);
                    world.func_72869_a("flame", (double)(xLoc - offset1), (double)yLoc, (double)(zLoc + offset2), 0.0, 0.0, 0.0);
                } else if (ordinal == 5) {
                    world.func_72869_a("smoke", (double)(xLoc + offset1), (double)yLoc, (double)(zLoc + offset2), 0.0, 0.0, 0.0);
                    world.func_72869_a("flame", (double)(xLoc + offset1), (double)yLoc, (double)(zLoc + offset2), 0.0, 0.0, 0.0);
                } else if (ordinal == 2) {
                    world.func_72869_a("smoke", (double)(xLoc + offset2), (double)yLoc, (double)(zLoc - offset1), 0.0, 0.0, 0.0);
                    world.func_72869_a("flame", (double)(xLoc + offset2), (double)yLoc, (double)(zLoc - offset1), 0.0, 0.0, 0.0);
                } else if (ordinal == 3) {
                    world.func_72869_a("smoke", (double)(xLoc + offset2), (double)yLoc, (double)(zLoc + offset1), 0.0, 0.0, 0.0);
                    world.func_72869_a("flame", (double)(xLoc + offset2), (double)yLoc, (double)(zLoc + offset1), 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileCoalGenerator();
    }

    @Override
    public void registerRecipes() {
        this.addRecipe((Block)this, new Object[]{"ISI", "CFC", "SSS", Character.valueOf('F'), Blocks.field_150460_al, Character.valueOf('I'), Items.field_151042_j, Character.valueOf('S'), "ingotSteel", Character.valueOf('C'), Blocks.field_150347_e});
    }
}

