/*
 * Decompiled with CFR 0.152.
 */
package physica.core.common.block;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import physica.api.core.abstraction.AbstractionLayer;
import physica.api.core.abstraction.Face;
import physica.api.core.abstraction.recipe.IRecipeRegister;
import physica.api.core.conductor.EnumConductorType;
import physica.api.core.conductor.IConductor;
import physica.api.core.utilities.IBaseUtilities;
import physica.core.common.CoreBlockRegister;
import physica.core.common.CoreTabRegister;
import physica.core.common.tile.TileEnergyCable;

public class BlockEnergyCable
extends Block
implements ITileEntityProvider,
IBaseUtilities,
IRecipeRegister {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;

    public BlockEnergyCable() {
        super(Material.field_151580_n);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.icons = new IIcon[EnumConductorType.values().length];
        }
        this.func_149711_c(3.5f);
        this.func_149672_a(field_149775_l);
        this.func_149752_b(0.2f);
        this.func_149663_c("physica:energyCable");
        this.func_149647_a(CoreTabRegister.coreTab);
        this.func_149676_a(0.34375f, 0.34375f, 0.34375f, 0.65625f, 0.65625f, 0.65625f);
        this.addToRegister("Core", this);
    }

    @Override
    public void registerRecipes() {
        this.addRecipe(new ItemStack((Block)CoreBlockRegister.blockCable, 6, 0), new Object[]{"WIW", "WIW", "WIW", Character.valueOf('W'), Blocks.field_150325_L, Character.valueOf('I'), "ingotCopper"});
        this.addRecipe(new ItemStack((Block)CoreBlockRegister.blockCable, 6, 0), new Object[]{"LIL", "LIL", "LIL", Character.valueOf('L'), Items.field_151116_aA, Character.valueOf('I'), "ingotCopper"});
        this.addRecipe(new ItemStack((Block)CoreBlockRegister.blockCable, 6, 0), new Object[]{"WWW", "III", "WWW", Character.valueOf('W'), Blocks.field_150325_L, Character.valueOf('I'), "ingotCopper"});
        this.addRecipe(new ItemStack((Block)CoreBlockRegister.blockCable, 6, 0), new Object[]{"LLL", "III", "LLL", Character.valueOf('L'), Items.field_151116_aA, Character.valueOf('I'), "ingotCopper"});
        this.addRecipe(new ItemStack((Block)CoreBlockRegister.blockCable, 6, 1), new Object[]{"WIW", "WIW", "WIW", Character.valueOf('W'), Blocks.field_150325_L, Character.valueOf('I'), "ingotSilver"});
        this.addRecipe(new ItemStack((Block)CoreBlockRegister.blockCable, 6, 1), new Object[]{"LIL", "LIL", "LIL", Character.valueOf('L'), Items.field_151116_aA, Character.valueOf('I'), "ingotSilver"});
        this.addRecipe(new ItemStack((Block)CoreBlockRegister.blockCable, 6, 1), new Object[]{"WWW", "III", "WWW", Character.valueOf('W'), Blocks.field_150325_L, Character.valueOf('I'), "ingotCopper"});
        this.addRecipe(new ItemStack((Block)CoreBlockRegister.blockCable, 6, 1), new Object[]{"LLL", "III", "LLL", Character.valueOf('L'), Items.field_151116_aA, Character.valueOf('I'), "ingotCopper"});
        this.addRecipe(new ItemStack((Block)CoreBlockRegister.blockCable, 6, 2), new Object[]{"WIW", "WIW", "WIW", Character.valueOf('W'), Blocks.field_150325_L, Character.valueOf('I'), "ingotGold"});
        this.addRecipe(new ItemStack((Block)CoreBlockRegister.blockCable, 6, 2), new Object[]{"LIL", "LIL", "LIL", Character.valueOf('L'), Items.field_151116_aA, Character.valueOf('I'), "ingotGold"});
        this.addRecipe(new ItemStack((Block)CoreBlockRegister.blockCable, 6, 2), new Object[]{"WWW", "III", "WWW", Character.valueOf('W'), Blocks.field_150325_L, Character.valueOf('I'), "ingotCopper"});
        this.addRecipe(new ItemStack((Block)CoreBlockRegister.blockCable, 6, 2), new Object[]{"LLL", "III", "LLL", Character.valueOf('L'), Items.field_151116_aA, Character.valueOf('I'), "ingotCopper"});
        this.addRecipe(new ItemStack((Block)CoreBlockRegister.blockCable, 6, 3), new Object[]{"WIW", "WIW", "WIW", Character.valueOf('W'), Blocks.field_150325_L, Character.valueOf('I'), "ingotSuperConductive"});
        this.addRecipe(new ItemStack((Block)CoreBlockRegister.blockCable, 6, 3), new Object[]{"LIL", "LIL", "LIL", Character.valueOf('L'), Items.field_151116_aA, Character.valueOf('I'), "ingotSuperConductive"});
        this.addRecipe(new ItemStack((Block)CoreBlockRegister.blockCable, 6, 3), new Object[]{"WWW", "III", "WWW", Character.valueOf('W'), Blocks.field_150325_L, Character.valueOf('I'), "ingotSuperConductive"});
        this.addRecipe(new ItemStack((Block)CoreBlockRegister.blockCable, 6, 3), new Object[]{"LLL", "III", "LLL", Character.valueOf('L'), Items.field_151116_aA, Character.valueOf('I'), "ingotSuperConductive"});
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return super.func_149668_a(world, x, y, z);
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        float tempMinX = 0.34375f;
        float tempMinY = 0.34375f;
        float tempMinZ = 0.34375f;
        float tempMaxX = 0.65625f;
        float tempMaxY = 0.65625f;
        float tempMaxZ = 0.65625f;
        block8: for (Face dir : Face.VALID) {
            TileEntity sideTile = world.func_147438_o(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
            if (!AbstractionLayer.Electricity.canConnectElectricity(sideTile, dir.getOpposite())) continue;
            switch (dir) {
                case DOWN: {
                    tempMinY -= 0.34375f;
                    continue block8;
                }
                case EAST: {
                    tempMaxX += 0.34375f;
                    continue block8;
                }
                case NORTH: {
                    tempMinZ -= 0.34375f;
                    continue block8;
                }
                case SOUTH: {
                    tempMaxZ += 0.34375f;
                    continue block8;
                }
                case UP: {
                    tempMaxY += 0.34375f;
                    continue block8;
                }
                case WEST: {
                    tempMinX -= 0.34375f;
                    continue block8;
                }
            }
        }
        this.func_149676_a(tempMinX, tempMinY, tempMinZ, tempMaxX, tempMaxY, tempMaxZ);
    }

    public void func_149726_b(World world, int x, int y, int z) {
        TileEntity tileEntity;
        super.func_149726_b(world, x, y, z);
        if (!world.field_72995_K && (tileEntity = world.func_147438_o(x, y, z)) instanceof IConductor) {
            ((IConductor)tileEntity).refreshNetwork();
        }
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        TileEntity tileEntity;
        super.func_149695_a(world, x, y, z, block);
        if (!world.field_72995_K && (tileEntity = world.func_147438_o(x, y, z)) instanceof IConductor) {
            ((IConductor)tileEntity).refreshNetwork();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        for (EnumConductorType type : EnumConductorType.values()) {
            this.icons[type.ordinal()] = reg.func_94245_a("physica:wire/" + type.asset());
        }
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.icons[meta];
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileEnergyCable();
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return -1;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149721_r() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (EnumConductorType type : EnumConductorType.values()) {
            list.add(new ItemStack(item, 1, type.ordinal()));
        }
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack itemStack) {
        world.func_72921_c(x, y, z, itemStack.func_77960_j(), 3);
    }

    public int func_149692_a(int metadata) {
        return metadata;
    }
}

