/*
 * Decompiled with CFR 0.152.
 */
package physica.core.common.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import physica.api.core.abstraction.Face;
import physica.api.core.abstraction.recipe.IRecipeRegister;
import physica.api.core.tile.IMachineTile;
import physica.api.core.utilities.IBaseUtilities;
import physica.core.common.CoreTabRegister;
import physica.library.block.BlockBaseContainer;
import physica.library.tile.TileBaseRotateable;

public abstract class BlockMachine
extends BlockBaseContainer
implements IBaseUtilities,
IRecipeRegister {
    private final Class<? extends TileEntity> tileClazz;
    public boolean hazard;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconFacing;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconFacingRunning;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconBottom;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconTop;

    public BlockMachine(String name, Class<? extends TileBaseRotateable> tileClazz) {
        super(Material.field_151573_f);
        this.tileClazz = tileClazz;
        this.func_149711_c(1.0f);
        this.func_149752_b(5.0f);
        this.setHarvestLevel("pickaxe", 2);
        this.func_149647_a(CoreTabRegister.coreTab);
        this.func_149663_c("physica:" + name);
        this.func_149658_d("physica:machine/" + name.toLowerCase());
        this.addToRegister("Core", this);
    }

    public void setHazard(boolean hazard) {
        this.hazard = hazard;
    }

    public void func_149651_a(IIconRegister reg) {
        if (this.hazard) {
            this.field_149761_L = reg.func_94245_a("physica:machine/machinesidehazmat");
            this.iconTop = reg.func_94245_a("physica:machine/machineside");
            this.iconBottom = reg.func_94245_a("physica:machine/machinebottomhazmat");
        } else {
            this.iconTop = this.iconBottom = reg.func_94245_a("physica:machine/machineside");
            this.field_149761_L = this.iconBottom;
        }
        this.iconFacing = reg.func_94245_a(this.func_149641_N() + "facing");
        this.iconFacingRunning = reg.func_94245_a(this.func_149641_N() + "facingrunning");
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof IMachineTile) {
            return ((IMachineTile)tile).isRunning() ? Blocks.field_150353_l.func_149750_m() : 0;
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        IMachineTile machine;
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof IMachineTile && (machine = (IMachineTile)tile).isRunning()) {
            world.func_72869_a("smoke", (double)((float)x + rand.nextFloat()), (double)((float)y + rand.nextFloat()), (double)((float)z + rand.nextFloat()), 0.0, 0.025, 0.0);
        }
    }

    public IIcon func_149673_e(IBlockAccess access, int x, int y, int z, int side) {
        TileEntity tile = access.func_147438_o(x, y, z);
        if (this.tileClazz.isInstance(tile) && tile instanceof IMachineTile) {
            Face facing = ((TileBaseRotateable)tile).getFacing();
            if (side == facing.ordinal()) {
                return ((IMachineTile)tile).isRunning() ? this.iconFacingRunning : this.iconFacing;
            }
            if (side == Face.DOWN.ordinal()) {
                return this.iconBottom;
            }
            if (side == Face.UP.ordinal()) {
                return this.iconTop;
            }
        }
        return this.field_149761_L;
    }

    public IIcon func_149691_a(int side, int meta) {
        if (side == 4) {
            return this.iconFacing;
        }
        if (side == 0) {
            return this.iconBottom;
        }
        if (side == 1) {
            return this.iconTop;
        }
        return this.field_149761_L;
    }

    public TileEntity func_149915_a(World world, int meta) {
        try {
            return this.tileClazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            return null;
        }
    }
}

