/*
 * Decompiled with CFR 0.152.
 */
package physica.core.common.event;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import defense.api.ExplosionEvent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.event.world.ExplosionEvent;
import physica.core.common.CoreBlockRegister;
import physica.core.common.tile.TileFulmination;
import physica.library.location.GridLocation;
import physica.nuclear.common.NuclearItemRegister;
import physica.nuclear.common.items.update.ItemUpdateAntimatter;
import resonant.api.explosion.ExplosionEvent;

public class FulminationEventHandler {
    public static final FulminationEventHandler INSTANCE = new FulminationEventHandler();
    private static final Set<TileFulmination> set = new HashSet<TileFulmination>();

    private static void onExplosionImpl(long energy, float size, World world, double x, double y, double z) {
        if (size > 0.0f && (energy *= 5L) > 0L) {
            Iterator<TileFulmination> iterator = set.iterator();
            while (iterator.hasNext()) {
                double distance;
                TileFulmination tile = iterator.next();
                if (tile.func_145837_r()) {
                    iterator.remove();
                    continue;
                }
                if (tile.func_145837_r() || world != tile.func_145831_w() || !((distance = tile.func_145835_a(x, y, z)) <= (double)size) || !(distance > 0.0)) continue;
                double electricity = Math.min((double)energy, (double)energy / (distance / (double)size));
                GridLocation loc = tile.getLocation();
                electricity = Math.max(electricity - (double)world.func_72842_a(Vec3.func_72443_a((double)x, (double)y, (double)z), CoreBlockRegister.blockFulmination.func_149668_a(world, loc.xCoord, loc.yCoord, loc.zCoord)) * electricity, 0.0);
                tile.setElectricityStored((int)((double)tile.getElectricityStored() + electricity));
            }
        }
    }

    public void register(TileFulmination tile) {
        set.add(tile);
    }

    public boolean isRegistered(TileFulmination tile) {
        return set.contains(tile);
    }

    public void unregister(TileFulmination tile) {
        set.remove(tile);
    }

    @SubscribeEvent
    public void onPreExplosion(ExplosionEvent.PostExplosionEvent event) {
        if (event.explosion != null) {
            float size = event.explosion.field_77280_f;
            FulminationEventHandler.onExplosionImpl(event.iExplosion.getEnergy(), size, event.world, event.x, event.y, event.z);
        }
    }

    @SubscribeEvent
    public void onExplosionEvent(ExplosionEvent event) {
        if (event.explosion != null) {
            float size = event.explosion.field_77280_f;
            FulminationEventHandler.onExplosionImpl(event.iExplosion.getEnergy(), size, event.world, event.x, event.y, event.z);
        }
    }

    @SubscribeEvent
    public void onExplosion(ExplosionEvent.Detonate event) {
        double energy = event.explosion.field_77280_f * 50.0f;
        if (Loader.isModLoaded((String)"physicanuclearphysics") && event.explosion.field_77283_e instanceof EntityItem && ((EntityItem)event.explosion.field_77283_e).func_92059_d().func_77973_b() == NuclearItemRegister.itemAntimatterCell1Gram) {
            energy *= (double)ItemUpdateAntimatter.FULMINATION_ANTIMATTER_ENERGY_SCALE;
        }
        if (event.explosion != null) {
            FulminationEventHandler.onExplosionImpl((long)energy, event.explosion.field_77280_f, event.world, event.explosion.field_77284_b, event.explosion.field_77285_c, event.explosion.field_77282_d);
        }
    }
}

