/*
 * Decompiled with CFR 0.152.
 */
package physica.core.common.items;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import physica.api.core.abstraction.AbstractionLayer;
import physica.api.core.abstraction.Face;
import physica.api.core.conductor.IConductor;
import physica.core.common.CoreTabRegister;
import physica.library.energy.ElectricityDisplay;
import physica.library.energy.ElectricityUtilities;
import physica.library.energy.base.Unit;
import physica.library.util.ChatUtilities;

public class ItemMultimeter
extends Item {
    public ItemMultimeter() {
        this.func_77655_b("multimeter");
        this.func_111206_d("physica:multimeter");
        this.func_77625_d(1);
        this.func_77637_a(CoreTabRegister.coreTab);
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        TileEntity tile = world.func_147438_o(x, y, z);
        Face dir = Face.getOrientation(side);
        if (tile instanceof IConductor) {
            if (!world.field_72995_K) {
                IConductor conductor = (IConductor)tile;
                player.func_145747_a((IChatComponent)new ChatComponentText("\u0421\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0430 \u0441\u0435\u0442\u0438"));
                player.func_145747_a((IChatComponent)new ChatComponentText(" - \u041f\u0440\u043e\u0432\u043e\u0434\u043d\u0438\u043a\u0438: " + conductor.getNetwork().conductorSet.size()));
                player.func_145747_a((IChatComponent)new ChatComponentText(" - \u0410\u043a\u0446\u0435\u043f\u0442\u043e\u0440\u044b: " + conductor.getNetwork().acceptorInputMap.size()));
                int voltage = conductor.getNetwork().getSafeVoltageLevel();
                player.func_145747_a((IChatComponent)new ChatComponentText(" - \u0411\u0435\u0437\u043e\u043f\u0430\u0441\u043d\u044b\u0439 \u0443\u0440\u043e\u0432\u0435\u043d\u044c \u043d\u0430\u043f\u0440\u044f\u0436\u0435\u043d\u0438\u044f: " + (voltage < 0 ? "\u0431\u0435\u0441\u043a. \u043d\u0430\u043f\u0440\u044f\u0436\u0435\u043d\u0438\u0435" : voltage + " \u0412\u043e\u043b\u044c\u0442")));
                player.func_145747_a((IChatComponent)new ChatComponentText(" - \u041e\u0431\u043c\u0435\u043d \u044d\u043d\u0435\u0440\u0433\u0438\u0438: " + ElectricityDisplay.getDisplay(ElectricityUtilities.convertEnergy(conductor.getNetwork().getEnergyTransmittedLastTick(), Unit.RF, Unit.WATT), Unit.WATT) + " / " + ElectricityDisplay.getDisplay(ElectricityUtilities.convertEnergy(conductor.getNetwork().getMaxPowerTransfer(), Unit.RF, Unit.WATT), Unit.WATT)));
            }
        } else {
            if (AbstractionLayer.Electricity.isElectricProvider(tile)) {
                ChatUtilities.addSpamlessMessages(2147483437, "\u0421\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0430 \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430 \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u044d\u043d\u0435\u0440\u0433\u0438\u0438", " - \u0425\u0440\u0430\u043d\u0438\u0442 \u044d\u043d\u0435\u0440\u0433\u0438\u0438: " + ElectricityDisplay.getDisplay(ElectricityUtilities.convertEnergy(AbstractionLayer.Electricity.getElectricityStored(tile, dir), Unit.RF, Unit.WATTHOUR), Unit.WATTHOUR) + " / " + ElectricityDisplay.getDisplay(ElectricityUtilities.convertEnergy(AbstractionLayer.Electricity.getElectricCapacity(tile, dir), Unit.RF, Unit.WATT), Unit.WATT), " - \u0411\u043e\u043a\u043e\u0432\u043e\u0439 \u0432\u044b\u0445\u043e\u0434: " + ElectricityDisplay.getDisplay(ElectricityUtilities.convertEnergy(AbstractionLayer.Electricity.extractElectricity(tile, dir, Integer.MAX_VALUE, true), Unit.RF, Unit.WATT), Unit.WATT));
                return true;
            }
            if (AbstractionLayer.Electricity.isElectricReceiver(tile)) {
                ChatUtilities.addSpamlessMessages(0x7FFFFF37, "\u0421\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0430 \u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a\u0430 \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u044d\u043d\u0435\u0440\u0433\u0438\u0438", " - \u0425\u0440\u0430\u043d\u0438\u0442 \u044d\u043d\u0435\u0440\u0433\u0438\u0438: " + ElectricityDisplay.getDisplay(ElectricityUtilities.convertEnergy(AbstractionLayer.Electricity.getElectricityStored(tile, dir), Unit.RF, Unit.WATTHOUR), Unit.WATTHOUR));
                return true;
            }
        }
        return super.onItemUseFirst(stack, player, world, x, y, z, side, hitX, hitY, hitZ);
    }
}

