/*
 * Decompiled with CFR 0.152.
 */
package physica.core.common.tile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import physica.api.core.abstraction.AbstractionLayer;
import physica.api.core.abstraction.Face;
import physica.api.core.electricity.IElectricityHandler;
import physica.api.core.inventory.IGuiInterface;
import physica.core.client.gui.GuiBatteryBox;
import physica.core.common.block.BlockBatteryBox;
import physica.core.common.inventory.ContainerBatteryBox;
import physica.library.location.GridLocation;
import physica.library.tile.TileBasePoweredContainer;

public class TileBatteryBox
extends TileBasePoweredContainer
implements IElectricityHandler,
IGuiInterface {
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_OUTPUT = 1;
    private static final int[] ACCESSIBLE_SLOTS_DOWN = new int[]{1};
    private static final int[] ACCESSIBLE_SLOTS_UP = new int[]{0};
    private TileEntity cachedOutput;

    @Override
    public int getElectricCapacity(Face from) {
        return BlockBatteryBox.EnumBatteryBox.values()[this.func_145832_p()].getCapacity();
    }

    @Override
    public void updateServer(int ticks) {
        super.updateServer(ticks);
        this.drainBattery(0);
        Face out = this.getFacing().getOpposite().getRelativeSide(Face.WEST);
        if (this.cachedOutput == null || this.cachedOutput.func_145837_r()) {
            this.cachedOutput = null;
            GridLocation loc = this.getLocation();
            TileEntity outputTile = this.getWorld().func_147438_o(loc.xCoord + out.offsetX, loc.yCoord + out.offsetY, loc.zCoord + out.offsetZ);
            if (AbstractionLayer.Electricity.isElectricReceiver(outputTile)) {
                this.cachedOutput = outputTile;
            }
        }
        if (this.cachedOutput != null && AbstractionLayer.Electricity.canConnectElectricity(this.cachedOutput, out.getOpposite())) {
            this.setElectricityStored(this.getElectricityStored() - AbstractionLayer.Electricity.receiveElectricity(this.cachedOutput, out.getOpposite(), Math.min(this.getElectricCapacity(Face.UNKNOWN) / 500, this.getElectricityStored()), false));
        }
        this.fillBattery(1);
    }

    @Override
    public int extractElectricity(Face from, int maxExtract, boolean simulate) {
        int removed;
        int n = removed = from != this.getFacing().getOpposite().getRelativeSide(Face.WEST) ? 0 : Math.min(Math.min(this.getElectricCapacity(Face.UNKNOWN) / 500, this.getElectricityStored()), Math.min(this.getElectricityStored(from), maxExtract));
        if (!simulate) {
            this.setElectricityStored(this.getElectricityStored(from) - removed);
        }
        return removed;
    }

    @Override
    public int receiveElectricity(Face from, int maxReceive, boolean simulate) {
        int received;
        maxReceive = Math.min(maxReceive, this.getElectricCapacity(Face.UNKNOWN) / 500);
        int capacityLeft = this.getElectricCapacity(from) - this.getElectricityStored();
        int n = received = from != this.getFacing().getOpposite().getRelativeSide(Face.EAST) ? 0 : Math.min(maxReceive, capacityLeft);
        if (!simulate) {
            this.setElectricityStored(this.getElectricityStored() + received);
        }
        return received;
    }

    @Override
    public boolean canConnectElectricity(Face from) {
        return from == this.getFacing().getOpposite().getRelativeSide(Face.WEST) || from == this.getFacing().getOpposite().getRelativeSide(Face.EAST);
    }

    @Override
    public int[] getAccessibleSlotsFromFace(Face face) {
        return face == Face.UP ? ACCESSIBLE_SLOTS_UP : (face == Face.DOWN ? ACCESSIBLE_SLOTS_DOWN : ACCESSIBLE_SLOTS_NONE);
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return AbstractionLayer.Electricity.isItemElectric(stack);
    }

    @Override
    public boolean canInsertItem(int slot, ItemStack stack, Face face) {
        return face == Face.UP && slot == 0 && this.func_94041_b(slot, stack);
    }

    @Override
    public boolean canExtractItem(int slot, ItemStack stack, Face face) {
        return face == Face.DOWN && slot == 1 && this.func_94041_b(slot, stack);
    }

    public int func_70302_i_() {
        return 2;
    }

    @Override
    public int getElectricityStored(Face from) {
        return super.getElectricityStored(from);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getClientGuiElement(int id, EntityPlayer player) {
        return new GuiBatteryBox(player, this);
    }

    @Override
    public Container getServerGuiElement(int id, EntityPlayer player) {
        return new ContainerBatteryBox(player, this);
    }
}

