/*
 * Decompiled with CFR 0.152.
 */
package physica.core.common.tile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.world.EnumSkyBlock;
import physica.api.core.abstraction.Face;
import physica.api.core.inventory.IGuiInterface;
import physica.core.client.gui.GuiBlastFurnace;
import physica.core.common.CoreItemRegister;
import physica.core.common.inventory.ContainerBlastFurnace;
import physica.library.location.GridLocation;
import physica.library.tile.TileBaseContainer;

public class TileBlastFurnace
extends TileBaseContainer
implements IGuiInterface {
    public static final int TOTAL_BURN_TIME = 200;
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_INPUTFUEL = 1;
    public static final int SLOT_OUTPUT = 2;
    private static final int[] ACCESSIBLE_SLOTS_TOP = new int[]{0};
    private static final int[] ACCESSIBLE_SLOTS_DOWN = new int[]{2};
    private static final int[] ACCESSIBLE_SLOTS_SIDES = new int[]{1};
    public int furnaceBurnTime;
    public int currentItemBurnTime;
    public int furnaceCookTime;

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.furnaceBurnTime = tag.func_74765_d("BurnTime");
        this.furnaceCookTime = tag.func_74765_d("CookTime");
        this.currentItemBurnTime = TileEntityFurnace.func_145952_a((ItemStack)this.func_70301_a(1));
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74777_a("BurnTime", (short)this.furnaceBurnTime);
        tag.func_74777_a("CookTime", (short)this.furnaceCookTime);
    }

    @SideOnly(value=Side.CLIENT)
    public int getCookProgressScaled(int scale) {
        return this.furnaceCookTime * scale / 200;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBurnTimeRemainingScaled(int scale) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = 200;
        }
        return this.furnaceBurnTime * scale / this.currentItemBurnTime;
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    @Override
    public void updateClient(int ticks) {
        super.updateClient(ticks);
        if (this.isBurning()) {
            GridLocation loc = this.getLocation();
            if (this.getWorld().field_73012_v.nextFloat() < 0.25f) {
                this.getWorld().func_72869_a("smoke", (double)loc.xCoord + 0.5, (double)loc.yCoord + 0.5, (double)loc.zCoord + 0.5, 0.0, (double)0.05f, 0.0);
            } else if (this.getWorld().field_73012_v.nextFloat() < 0.025f) {
                this.getWorld().func_72869_a("lava", (double)loc.xCoord + 0.5, (double)loc.yCoord + 0.5, (double)loc.zCoord + 0.5, 0.0, (double)0.05f, 0.0);
            }
        }
    }

    @Override
    public void updateServer(int ticks) {
        super.updateServer(ticks);
        if (this.furnaceBurnTime > 0) {
            --this.furnaceBurnTime;
        }
        ItemStack stackInputFuel = this.func_70301_a(1);
        if (!this.getWorld().field_72995_K && (this.furnaceBurnTime != 0 || stackInputFuel != null && this.func_70301_a(0) != null)) {
            if (this.furnaceBurnTime == 0 && this.canSmelt()) {
                this.currentItemBurnTime = this.furnaceBurnTime = TileEntityFurnace.func_145952_a((ItemStack)stackInputFuel);
                if (this.furnaceBurnTime > 0 && stackInputFuel != null) {
                    --stackInputFuel.field_77994_a;
                    if (stackInputFuel.field_77994_a == 0) {
                        this.func_70299_a(1, stackInputFuel.func_77973_b().getContainerItem(stackInputFuel));
                    }
                }
            }
            if (this.isBurning() && this.canSmelt()) {
                ++this.furnaceCookTime;
                if (this.furnaceCookTime == 200) {
                    this.furnaceCookTime = 0;
                    this.smeltItem();
                }
            } else {
                this.furnaceCookTime = 0;
            }
        }
    }

    @Override
    public void writeSynchronizationPacket(List<Object> dataList, EntityPlayer player) {
        super.writeSynchronizationPacket(dataList, player);
        dataList.add(this.furnaceBurnTime);
        dataList.add(this.currentItemBurnTime);
        dataList.add(this.furnaceCookTime);
    }

    @Override
    public void readSynchronizationPacket(ByteBuf buf, EntityPlayer player) {
        super.readSynchronizationPacket(buf, player);
        this.furnaceBurnTime = buf.readInt();
        this.currentItemBurnTime = buf.readInt();
        this.furnaceCookTime = buf.readInt();
        GridLocation loc = this.getLocation();
        this.getWorld().func_147463_c(EnumSkyBlock.Block, loc.xCoord, loc.yCoord, loc.zCoord);
    }

    @Override
    public int getSyncRate() {
        return 10;
    }

    private boolean canSmelt() {
        ItemStack recipe2;
        ItemStack input = this.func_70301_a(0);
        if (input == null) {
            return false;
        }
        if (input.field_77994_a < 2) {
            return false;
        }
        ItemStack itemStack = recipe2 = input.func_77973_b() == Items.field_151042_j && input.field_77994_a >= 2 ? new ItemStack((Item)CoreItemRegister.itemMetaIngot, 1, 2) : null;
        if (recipe2 == null) {
            return false;
        }
        ItemStack output = this.func_70301_a(2);
        if (output == null) {
            return true;
        }
        if (!output.func_77969_a(recipe2)) {
            return false;
        }
        int result = output.field_77994_a + recipe2.field_77994_a;
        return result <= this.func_70297_j_() && result <= output.func_77976_d();
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack input = this.func_70301_a(0);
            ItemStack recipe2 = input.func_77973_b() == Items.field_151042_j && input.field_77994_a >= 2 ? new ItemStack((Item)CoreItemRegister.itemMetaIngot, 1, 2) : null;
            ItemStack output = this.func_70301_a(2);
            if (recipe2 != null) {
                if (output == null) {
                    this.func_70299_a(2, recipe2.func_77946_l());
                } else if (output.func_77973_b() == recipe2.func_77973_b()) {
                    output.field_77994_a += recipe2.field_77994_a;
                }
                input.field_77994_a -= 2;
                if (input.field_77994_a <= 1) {
                    this.func_70299_a(0, null);
                }
            }
        }
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot != 2 && (slot == 1 ? TileEntityFurnace.func_145954_b((ItemStack)stack) : stack != null && stack.func_77973_b() == Items.field_151042_j);
    }

    @Override
    public int[] getAccessibleSlotsFromFace(Face face) {
        return face == Face.DOWN ? ACCESSIBLE_SLOTS_DOWN : (face == Face.UP ? ACCESSIBLE_SLOTS_TOP : ACCESSIBLE_SLOTS_SIDES);
    }

    @Override
    public boolean canInsertItem(int slot, ItemStack stack, Face face) {
        return this.func_94041_b(slot, stack);
    }

    @Override
    public boolean canExtractItem(int slot, ItemStack stack, Face face) {
        return face != Face.DOWN || slot != 1 || stack.func_77973_b() == Items.field_151133_ar;
    }

    public int func_70302_i_() {
        return 3;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getClientGuiElement(int id, EntityPlayer player) {
        return new GuiBlastFurnace(player, this);
    }

    @Override
    public Container getServerGuiElement(int id, EntityPlayer player) {
        return new ContainerBlastFurnace(player, this);
    }
}

