/*
 * Decompiled with CFR 0.152.
 */
package physica.core.common.tile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.world.EnumSkyBlock;
import physica.api.core.abstraction.Face;
import physica.api.core.inventory.IGuiInterface;
import physica.api.core.tile.IMachineTile;
import physica.core.client.gui.GuiCircuitPress;
import physica.core.common.inventory.ContainerCircuitPress;
import physica.core.common.recipe.CircuitPressRecipeHandler;
import physica.library.energy.ElectricityUtilities;
import physica.library.energy.base.Unit;
import physica.library.location.GridLocation;
import physica.library.recipe.RecipeSystem;
import physica.library.tile.TileBasePoweredContainer;
import physica.library.util.OreDictionaryUtilities;

public class TileCircuitPress
extends TileBasePoweredContainer
implements IGuiInterface,
IMachineTile {
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_INPUT2 = 1;
    public static final int SLOT_OUTPUT = 2;
    public static final int TICKS_REQUIRED = 80;
    public static final int POWER_USAGE = ElectricityUtilities.convertEnergy(1000, Unit.WATT, Unit.RF);
    private static final int[] ACCESSIBLE_SLOTS_TOP = new int[]{0};
    private static final int[] ACCESSIBLE_SLOTS_DOWN = new int[]{2};
    private static final int[] ACCESSIBLE_SLOTS_SIDES = new int[]{1};
    protected int operatingTicks = 0;

    @Override
    public boolean isRunning() {
        return this.operatingTicks > 0;
    }

    @Override
    public void writeClientGuiPacket(List<Object> dataList, EntityPlayer player) {
        super.writeClientGuiPacket(dataList, player);
        dataList.add(this.operatingTicks);
    }

    @Override
    public void readClientGuiPacket(ByteBuf buf, EntityPlayer player) {
        super.readClientGuiPacket(buf, player);
        int prevOperatingTicks = this.operatingTicks;
        this.operatingTicks = buf.readInt();
        if (prevOperatingTicks == 0 && this.operatingTicks > 0 || prevOperatingTicks > 0 && this.operatingTicks == 0) {
            GridLocation loc = this.getLocation();
            this.getWorld().func_147463_c(EnumSkyBlock.Block, loc.xCoord, loc.yCoord, loc.zCoord);
        }
    }

    public int getOperatingTicks() {
        return this.operatingTicks;
    }

    @Override
    public void updateServer(int ticks) {
        super.updateServer(ticks);
        if (this.hasEnoughEnergy()) {
            ItemStack input2;
            ItemStack input;
            ItemStack output = this.func_70301_a(2);
            if (this.canProcess(output, input = this.func_70301_a(0), input2 = this.func_70301_a(1))) {
                if (this.operatingTicks < 80) {
                    ++this.operatingTicks;
                } else {
                    this.process(input, input2, output);
                    this.operatingTicks = 0;
                }
                this.extractEnergy();
            } else {
                this.operatingTicks = 0;
            }
        }
    }

    public boolean canProcess(ItemStack output, ItemStack input, ItemStack input2) {
        if (input == null || input2 == null || output != null && output.field_77994_a >= output.func_77976_d()) {
            return false;
        }
        CircuitPressRecipeHandler currentRecipe = (CircuitPressRecipeHandler)RecipeSystem.getRecipe(this.getClass(), input);
        if (currentRecipe != null) {
            return OreDictionaryUtilities.isSameOre(input, currentRecipe.getOredict()) && OreDictionaryUtilities.isSameOre(input2, currentRecipe.getOredict2()) && (output == null || currentRecipe.getOutput().func_77969_a(output));
        }
        return false;
    }

    private void process(ItemStack input, ItemStack input2, ItemStack output) {
        if (output == null) {
            output = ((CircuitPressRecipeHandler)RecipeSystem.getRecipe(this.getClass(), input)).getOutput().func_77946_l();
        } else {
            ++output.field_77994_a;
        }
        this.func_70299_a(2, output);
        --input.field_77994_a;
        if (input.field_77994_a <= 0) {
            this.func_70299_a(0, null);
        }
        --input2.field_77994_a;
        if (input2.field_77994_a <= 0) {
            this.func_70299_a(1, null);
        }
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot == 2 || stack == null) {
            return false;
        }
        if (slot == 0) {
            return RecipeSystem.isRecipeInput(this.getClass(), stack);
        }
        if (slot == 1) {
            for (CircuitPressRecipeHandler recipe2 : RecipeSystem.getHandleRecipes(this.getClass())) {
                if (!OreDictionaryUtilities.isSameOre(stack, recipe2.getOredict2())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int[] getAccessibleSlotsFromFace(Face face) {
        return face == Face.DOWN ? ACCESSIBLE_SLOTS_DOWN : (face == Face.UP ? ACCESSIBLE_SLOTS_TOP : ACCESSIBLE_SLOTS_SIDES);
    }

    @Override
    public boolean canInsertItem(int slot, ItemStack stack, Face face) {
        return this.func_94041_b(slot, stack);
    }

    @Override
    public boolean canExtractItem(int slot, ItemStack stack, Face face) {
        return true;
    }

    @Override
    public int getPowerUsage() {
        return POWER_USAGE;
    }

    public int func_70302_i_() {
        return 3;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getClientGuiElement(int id, EntityPlayer player) {
        return new GuiCircuitPress(player, this);
    }

    @Override
    public Container getServerGuiElement(int id, EntityPlayer player) {
        return new ContainerCircuitPress(player, this);
    }
}

