/*
 * Decompiled with CFR 0.152.
 */
package physica.core.common.tile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.EnumSkyBlock;
import physica.api.core.abstraction.AbstractionLayer;
import physica.api.core.abstraction.Face;
import physica.api.core.electricity.IElectricityProvider;
import physica.api.core.inventory.IGuiInterface;
import physica.api.core.tile.IMachineTile;
import physica.core.client.gui.GuiCoalGenerator;
import physica.core.common.inventory.ContainerCoalGenerator;
import physica.library.location.GridLocation;
import physica.library.tile.TileBaseContainer;

public class TileCoalGenerator
extends TileBaseContainer
implements IGuiInterface,
IElectricityProvider,
IMachineTile {
    public static final int SLOT_INPUT = 0;
    public static final int MAX_GENERATE = 500;
    public static final int MIN_GENERATE = 5;
    private static final int[] ACCESSIBLE_SLOTS = new int[]{0};
    private static final float BASE_ACCELERATION = 0.3f;
    public double prevGenerateWatts;
    public double generate;
    public int itemCookTime;
    private TileEntity cachedOutput;

    @Override
    public boolean canConnectElectricity(Face from) {
        return from == this.getFacing().getOpposite();
    }

    @Override
    public boolean isRunning() {
        return this.generate > 0.0;
    }

    @Override
    public void updateServer(int ticks) {
        super.updateServer(ticks);
        this.prevGenerateWatts = this.generate;
        if (this.itemCookTime > 0) {
            --this.itemCookTime;
            this.generate = Math.min(this.generate + Math.min(this.generate * 0.005 + (double)0.3f, 5.0), 500.0);
        }
        if (this.func_70301_a(0) != null && this.func_70301_a(0).func_77973_b() == Items.field_151044_h && this.itemCookTime <= 0) {
            this.itemCookTime = 320;
            this.func_70298_a(0, 1);
        }
        if (this.generate - 5.0 > 0.0) {
            Face out = this.getFacing().getOpposite();
            if (this.cachedOutput == null || this.cachedOutput.func_145837_r()) {
                this.cachedOutput = null;
                GridLocation loc = this.getLocation();
                TileEntity outputTile = this.getWorld().func_147438_o(loc.xCoord + out.offsetX, loc.yCoord + out.offsetY, loc.zCoord + out.offsetZ);
                if (AbstractionLayer.Electricity.isElectricReceiver(outputTile)) {
                    this.cachedOutput = outputTile;
                }
            }
            if (this.cachedOutput != null && AbstractionLayer.Electricity.canConnectElectricity(this.cachedOutput, out.getOpposite())) {
                AbstractionLayer.Electricity.receiveElectricity(this.cachedOutput, out.getOpposite(), (int)this.generate - 100, false);
            }
        }
        if (this.itemCookTime <= 0) {
            this.generate = Math.max(this.generate - 8.0, 0.0);
        }
    }

    @Override
    public void readSynchronizationPacket(ByteBuf buf, EntityPlayer player) {
        double prevGenerate = this.generate;
        super.readSynchronizationPacket(buf, player);
        if (prevGenerate == 0.0 && this.generate > 0.0 || prevGenerate > 0.0 && (int)this.generate == 0) {
            GridLocation loc = this.getLocation();
            this.getWorld().func_147463_c(EnumSkyBlock.Block, loc.xCoord, loc.yCoord, loc.zCoord);
            this.getWorld().func_147458_c(loc.xCoord, loc.yCoord, loc.zCoord, loc.xCoord, loc.yCoord, loc.zCoord);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74768_a("itemCookTime", this.itemCookTime);
        tag.func_74780_a("generateRate", this.generate);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.itemCookTime = tag.func_74762_e("itemCookTime");
        this.generate = tag.func_74769_h("generateRate");
    }

    @Override
    public void writeClientGuiPacket(List<Object> dataList, EntityPlayer player) {
        super.writeClientGuiPacket(dataList, player);
        dataList.add(this.generate);
        dataList.add(this.itemCookTime);
    }

    @Override
    public void readClientGuiPacket(ByteBuf buf, EntityPlayer player) {
        super.readClientGuiPacket(buf, player);
        this.generate = buf.readDouble();
        this.itemCookTime = buf.readInt();
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return stack != null && stack.func_77973_b() == Items.field_151044_h;
    }

    @Override
    public int[] getAccessibleSlotsFromFace(Face face) {
        return ACCESSIBLE_SLOTS;
    }

    @Override
    public boolean canInsertItem(int slot, ItemStack stack, Face face) {
        return this.func_94041_b(slot, stack);
    }

    public int func_70302_i_() {
        return 1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getClientGuiElement(int id, EntityPlayer player) {
        return new GuiCoalGenerator(player, this);
    }

    @Override
    public Container getServerGuiElement(int id, EntityPlayer player) {
        return new ContainerCoalGenerator(player, this);
    }

    @Override
    public int getElectricityStored(Face from) {
        return this.generate > 5.0 ? (int)this.generate - 100 : 0;
    }

    @Override
    public int extractElectricity(Face from, int maxExtract, boolean simulate) {
        return from == this.getFacing().getOpposite() ? this.getElectricityStored(from) : 0;
    }

    @Override
    public int getElectricCapacity(Face from) {
        return 400;
    }
}

