/*
 * Decompiled with CFR 0.152.
 */
package physica.core.common.tile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.world.EnumSkyBlock;
import net.minecraftforge.oredict.OreDictionary;
import physica.api.core.abstraction.AbstractionLayer;
import physica.api.core.abstraction.Face;
import physica.api.core.inventory.IGuiInterface;
import physica.api.core.tile.IMachineTile;
import physica.core.client.gui.GuiElectricFurnace;
import physica.core.common.block.BlockElectricFurnace;
import physica.core.common.inventory.ContainerElectricFurnace;
import physica.library.energy.ElectricityUtilities;
import physica.library.energy.base.Unit;
import physica.library.location.GridLocation;
import physica.library.tile.TileBasePoweredContainer;

public class TileElectricFurnace
extends TileBasePoweredContainer
implements IGuiInterface,
IMachineTile {
    public static final int TICKS_REQUIRED = 100;
    public static final int POWER_USAGE = ElectricityUtilities.convertEnergy(1000, Unit.WATT, Unit.RF);
    public static final int SLOT_ENERGY = 0;
    public static final int SLOT_INPUT = 1;
    public static final int SLOT_OUTPUT = 2;
    private static final int[] ACCESSIBLE_SLOTS_DOWN = new int[]{2};
    private static final int[] ACCESSIBLE_SLOTS_UP = new int[]{1};
    protected int operatingTicks = 0;

    @Override
    public boolean isRunning() {
        return this.operatingTicks > 0;
    }

    @Override
    public void updateServer(int ticks) {
        super.updateServer(ticks);
        if (this.hasEnoughEnergy()) {
            ItemStack input;
            ItemStack output = this.func_70301_a(2);
            if (this.canProcess(output, input = this.func_70301_a(1))) {
                if (this.operatingTicks < 100) {
                    ++this.operatingTicks;
                } else {
                    this.process(input, output);
                    this.operatingTicks = 0;
                }
                this.extractEnergy();
            } else {
                this.operatingTicks = 0;
            }
            this.drainBattery(0);
        } else {
            this.drainBattery(0);
        }
    }

    public boolean canProcess(ItemStack output, ItemStack input) {
        if (input == null) {
            return false;
        }
        if (FurnaceRecipes.func_77602_a().func_151395_a(input) == null) {
            return false;
        }
        if (output != null) {
            if (!output.func_77969_a(FurnaceRecipes.func_77602_a().func_151395_a(input))) {
                return false;
            }
            return output.field_77994_a + (this.func_145832_p() == BlockElectricFurnace.EnumElectricFurnace.INDUSTRIAL.ordinal() ? 2 : 1) <= 64;
        }
        return true;
    }

    private void process(ItemStack input, ItemStack output) {
        ItemStack resultItemStack = FurnaceRecipes.func_77602_a().func_151395_a(input);
        int stackSize = 1;
        if (this.func_145832_p() == BlockElectricFurnace.EnumElectricFurnace.INDUSTRIAL.ordinal()) {
            boolean isOre = false;
            for (int id : OreDictionary.getOreIDs((ItemStack)input)) {
                if (!OreDictionary.getOreName((int)id).startsWith("ore")) continue;
                isOre = true;
                break;
            }
            if (isOre) {
                for (int id : OreDictionary.getOreIDs((ItemStack)resultItemStack)) {
                    if (!OreDictionary.getOreName((int)id).startsWith("ingot")) continue;
                    stackSize = 2;
                    break;
                }
            }
        }
        if (output == null) {
            ItemStack finalStack = resultItemStack.func_77946_l();
            finalStack.field_77994_a = stackSize;
            this.func_70299_a(2, finalStack);
        } else if (output.func_77969_a(resultItemStack)) {
            output.field_77994_a += stackSize;
        }
        --input.field_77994_a;
        if (input.field_77994_a <= 0) {
            this.func_70299_a(1, null);
        }
    }

    @Override
    public void writeClientGuiPacket(List<Object> dataList, EntityPlayer player) {
        super.writeClientGuiPacket(dataList, player);
        dataList.add(this.operatingTicks);
    }

    @Override
    public void readClientGuiPacket(ByteBuf buf, EntityPlayer player) {
        super.readClientGuiPacket(buf, player);
        int prevOperatingTicks = this.operatingTicks;
        this.operatingTicks = buf.readInt();
        if (prevOperatingTicks == 0 && this.operatingTicks > 0 || prevOperatingTicks > 0 && this.operatingTicks == 0) {
            GridLocation loc = this.getLocation();
            this.getWorld().func_147463_c(EnumSkyBlock.Block, loc.xCoord, loc.yCoord, loc.zCoord);
        }
    }

    public int getOperatingTicks() {
        return this.operatingTicks;
    }

    public int func_70302_i_() {
        return 3;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack itemStack) {
        return slot == 1 ? FurnaceRecipes.func_77602_a().func_151395_a(itemStack) != null : slot == 0 && AbstractionLayer.Electricity.isItemElectric(itemStack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getClientGuiElement(int id, EntityPlayer player) {
        return new GuiElectricFurnace(player, this);
    }

    @Override
    public Container getServerGuiElement(int id, EntityPlayer player) {
        return new ContainerElectricFurnace(player, this);
    }

    @Override
    public int getPowerUsage() {
        return POWER_USAGE * 3;
    }

    @Override
    public int[] getAccessibleSlotsFromFace(Face face) {
        return face == Face.DOWN ? ACCESSIBLE_SLOTS_DOWN : (face == Face.UP ? ACCESSIBLE_SLOTS_UP : ACCESSIBLE_SLOTS_NONE);
    }

    @Override
    public boolean canInsertItem(int slot, ItemStack stack, Face face) {
        return this.func_94041_b(slot, stack);
    }

    @Override
    public boolean canExtractItem(int slot, ItemStack stack, Face face) {
        return slot == 2;
    }
}

