/*
 * Decompiled with CFR 0.152.
 */
package physica.core.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import physica.api.core.abstraction.AbstractionLayer;
import physica.api.core.abstraction.Face;
import physica.api.core.electricity.IElectricityProvider;
import physica.core.common.event.FulminationEventHandler;
import physica.library.location.GridLocation;
import physica.library.tile.TileBase;

public class TileFulmination
extends TileBase
implements IElectricityProvider {
    public static int MAX_ENERGY_STORED = 500000;
    private int energyStored;

    public int getElectricityStored() {
        return this.energyStored;
    }

    @Override
    public void setElectricityStored(int energy) {
        this.energyStored = Math.min(energy, MAX_ENERGY_STORED);
    }

    @Override
    public void updateServer(int ticks) {
        super.updateServer(ticks);
        if (!FulminationEventHandler.INSTANCE.isRegistered(this)) {
            FulminationEventHandler.INSTANCE.register(this);
        }
        GridLocation loc = this.getLocation();
        if (this.energyStored > 0 && ticks % 20 == 0) {
            for (Face dir : Face.VALID) {
                TileEntity tile = this.getWorld().func_147438_o(loc.xCoord + dir.offsetX, loc.yCoord + dir.offsetY, loc.zCoord + dir.offsetZ);
                if (tile == null || !AbstractionLayer.Electricity.isElectricReceiver(tile) || !AbstractionLayer.Electricity.canConnectElectricity(tile, dir.getOpposite())) continue;
                this.energyStored -= AbstractionLayer.Electricity.receiveElectricity(tile, dir.getOpposite(), this.energyStored, false);
            }
        }
    }

    @Override
    public void writeSynchronizationPacket(List<Object> dataList, EntityPlayer player) {
        super.writeSynchronizationPacket(dataList, player);
        dataList.add(this.energyStored);
    }

    @Override
    public void readSynchronizationPacket(ByteBuf buf, EntityPlayer player) {
        super.readSynchronizationPacket(buf, player);
        this.energyStored = buf.readInt();
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74768_a("energyStored", this.energyStored);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.energyStored = tag.func_74762_e("energyStored");
    }

    @Override
    public int getElectricCapacity(Face from) {
        return MAX_ENERGY_STORED;
    }

    @Override
    public boolean canConnectElectricity(Face from) {
        return true;
    }

    @Override
    public int extractElectricity(Face from, int maxExtract, boolean simulate) {
        int value = Math.min(5000, this.energyStored);
        if (!simulate) {
            this.energyStored -= value;
        }
        return value;
    }

    @Override
    public int getElectricityStored(Face from) {
        return this.energyStored;
    }
}

