/*
 * Decompiled with CFR 0.152.
 */
package physica.library.block;

import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import physica.api.core.PhysicaAPI;
import physica.api.core.abstraction.Face;
import physica.api.core.misc.IRotatable;

public abstract class BlockRotatable
extends BlockContainer {
    protected byte rotationMask = Byte.parseByte("111100", 2);
    protected boolean isFlipPlacement = false;

    protected BlockRotatable(Material material) {
        super(material);
    }

    public boolean canRotate(int ordinal) {
        return (this.rotationMask & 1 << ordinal) != 0;
    }

    public int determineOrientation(World world, int x, int y, int z, EntityLivingBase entity) {
        int returnSide;
        int playerSide;
        if (MathHelper.func_76135_e((float)((float)entity.field_70165_t - (float)x)) < 2.0f && MathHelper.func_76135_e((float)((float)entity.field_70161_v - (float)z)) < 2.0f) {
            double d0 = entity.field_70163_u + 1.82 - (double)entity.field_70129_M;
            if (this.canRotate(1) && d0 - (double)y > 2.0) {
                return 1;
            }
            if (this.canRotate(0) && (double)y - d0 > 0.0) {
                return 0;
            }
        }
        int n = (playerSide = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3) == 3 && this.canRotate(4) ? 4 : (playerSide == 2 && this.canRotate(3) ? 3 : (playerSide == 1 && this.canRotate(5) ? 5 : (returnSide = playerSide == 0 && this.canRotate(2) ? 2 : 0)));
        if (this.isFlipPlacement) {
            return Face.getOrientation(returnSide).getOpposite().ordinal();
        }
        return returnSide;
    }

    public ForgeDirection[] getValidRotations(World world, int x, int y, int z) {
        return ForgeDirection.VALID_DIRECTIONS;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float xHit, float yHit, float zHit) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof IRotatable && PhysicaAPI.isDebugMode && !world.field_72995_K && player.func_70003_b(2, "")) {
            player.func_146105_b((IChatComponent)new ChatComponentText("Server: " + !world.field_72995_K + ", Rotation: " + (Object)((Object)((IRotatable)tile).getFacing())));
        }
        return true;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack item) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof IRotatable) {
            IRotatable tileRotatable = (IRotatable)tile;
            tileRotatable.setFacing(Face.VALID[this.determineOrientation(world, x, y, z, entity)]);
        }
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection side) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof IRotatable) {
            IRotatable tileRotatable = (IRotatable)tile;
            tileRotatable.setFacing(Face.Parse(side));
            return true;
        }
        return false;
    }
}

